/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import java.util.List;
import javax.annotation.Nullable;

@Internal
public class SmartHttpContentCompressor
extends HttpContentCompressor {
    private boolean skipEncoding = false;
    private final int compressionThreshold;

    SmartHttpContentCompressor(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    @Internal
    public SmartHttpContentCompressor() {
        this(1024);
    }

    public boolean shouldSkip(@Nullable String contentType, @Nullable Integer contentLength) {
        if (contentType == null) {
            return true;
        }
        return !MediaType.isTextBased((String)contentType) || contentLength != null && contentLength >= 0 && contentLength < this.compressionThreshold;
    }

    public boolean shouldSkip(HttpHeaders headers) {
        return this.shouldSkip(headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE), headers.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
    }

    protected void encode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            HttpHeaders headers = res.headers();
            this.skipEncoding = this.shouldSkip(headers);
        }
        super.encode(ctx, msg, out);
    }

    protected HttpContentEncoder.Result beginEncode(HttpResponse headers, String acceptEncoding) throws Exception {
        if (this.skipEncoding) {
            return null;
        }
        return super.beginEncode(headers, acceptEncoding);
    }
}

