/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.decoders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.runtime.server.EmbeddedServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Internal
public class HttpRequestDecoder
extends MessageToMessageDecoder<HttpRequest>
implements Ordered {
    public static final String ID = "micronaut-http-decoder";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final EmbeddedServer embeddedServer;
    private final ConversionService<?> conversionService;
    private final HttpServerConfiguration configuration;

    public HttpRequestDecoder(EmbeddedServer embeddedServer, ConversionService<?> conversionService, HttpServerConfiguration configuration) {
        this.embeddedServer = embeddedServer;
        this.conversionService = conversionService;
        this.configuration = configuration;
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server {}:{} Received Request: {} {}", new Object[]{this.embeddedServer.getHost(), this.embeddedServer.getPort(), msg.method(), msg.uri()});
        }
        out.add((Object)new NettyHttpRequest(msg, ctx, this.conversionService, this.configuration));
    }
}

