/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.PartData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

@Internal
public class NettyPartData
implements PartData {
    private final FileUpload fileUpload;
    private final int start;
    private final int length;

    public NettyPartData(FileUpload fileUpload, int start, int length) {
        this.fileUpload = fileUpload;
        this.start = start;
        this.length = length;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteBufInputStream(this.getByteBuf(), true);
    }

    public byte[] getBytes() throws IOException {
        ByteBuf byteBuf = this.getByteBuf();
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            byteBuf.release();
        }
    }

    public ByteBuffer getByteBuffer() throws IOException {
        ByteBuf byteBuf = this.getByteBuf();
        try {
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            return byteBuffer;
        }
        finally {
            byteBuf.release();
        }
    }

    public Optional<MediaType> getContentType() {
        return Optional.of(MediaType.of((CharSequence)this.fileUpload.getContentType()));
    }

    public ByteBuf getByteBuf() throws IOException {
        return this.fileUpload.getByteBuf().retainedSlice(this.start, this.length);
    }
}

