/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.SystemFileCustomizableResponseType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Optional;

public class NettySystemFileCustomizableResponseType
extends SystemFileCustomizableResponseType
implements NettyFileCustomizableResponseType {
    private static final int LENGTH_8K = 8192;
    protected final RandomAccessFile raf;
    protected final long rafLength;
    protected Optional<SystemFileCustomizableResponseType> delegate = Optional.empty();

    public NettySystemFileCustomizableResponseType(File file) {
        super(file);
        try {
            this.raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new CustomizableResponseTypeException("Could not find file", (Throwable)e);
        }
        try {
            this.rafLength = this.raf.length();
        }
        catch (IOException e) {
            throw new CustomizableResponseTypeException("Could not determine file length", (Throwable)e);
        }
    }

    public NettySystemFileCustomizableResponseType(SystemFileCustomizableResponseType delegate) {
        this(delegate.getFile());
        this.delegate = Optional.of(delegate);
    }

    public long getLength() {
        return this.rafLength;
    }

    public long getLastModified() {
        return this.delegate.map(SystemFileCustomizableResponseType::getLastModified).orElse(super.getLastModified());
    }

    public String getName() {
        return this.delegate.map(SystemFileCustomizableResponseType::getName).orElse(super.getName());
    }

    public void process(MutableHttpResponse response) {
        response.header((CharSequence)"Content-Length", (CharSequence)String.valueOf(this.getLength()));
        this.delegate.ifPresent(type -> type.process(response));
    }

    @Override
    public void write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        if (response instanceof NettyMutableHttpResponse) {
            FullHttpResponse nettyResponse = ((NettyMutableHttpResponse)response).getNativeResponse();
            HttpHeaders headers = nettyResponse.headers();
            context.write((Object)new DefaultHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), headers), context.voidPromise());
            if (context.pipeline().get(SslHandler.class) == null && ((SmartHttpContentCompressor)context.pipeline().get(SmartHttpContentCompressor.class)).shouldSkip(headers)) {
                context.write((Object)new DefaultFileRegion(this.raf.getChannel(), 0L, this.getLength()), (ChannelPromise)context.newProgressivePromise());
                context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                try {
                    context.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(this.raf, 0L, this.getLength(), 8192)), (ChannelPromise)context.newProgressivePromise());
                }
                catch (IOException e) {
                    throw new CustomizableResponseTypeException("Could not read file", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
    }
}

