/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import javax.inject.Inject;
import javax.inject.Singleton;

@Internal
@Singleton
class DefaultHttpCompressionStrategy
implements HttpCompressionStrategy {
    private final int compressionThreshold;

    @Inject
    DefaultHttpCompressionStrategy(NettyHttpServerConfiguration serverConfiguration) {
        this.compressionThreshold = serverConfiguration.getCompressionThreshold();
    }

    DefaultHttpCompressionStrategy(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    @Override
    public boolean shouldCompress(HttpResponse response) {
        HttpHeaders headers = response.headers();
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Integer contentLength = headers.getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        return contentType != null && (contentLength == null || contentLength >= this.compressionThreshold) && MediaType.isTextBased((String)contentType);
    }
}

