/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

@Requirements(value={@Requires(property="micronaut.ssl.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.ssl.build-self-signed", value="false", defaultValue="false")})
@Singleton
@Internal
public class CertificateProvidedSslBuilder
extends SslBuilder<SslContext>
implements ServerSslBuilder {
    public CertificateProvidedSslBuilder(ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super((SslConfiguration)ssl, resourceResolver);
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return (ServerSslConfiguration)this.ssl;
    }

    @Override
    public Optional<SslContext> build() {
        SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory()).trustManager(this.getTrustManagerFactory());
        if (this.ssl.getProtocols().isPresent()) {
            sslBuilder.protocols((String[])this.ssl.getProtocols().get());
        }
        if (this.ssl.getCiphers().isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((Object[])this.ssl.getCiphers().get()));
        }
        if (this.ssl.getClientAuthentication().isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)this.ssl.getClientAuthentication().get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        try {
            return Optional.of(sslBuilder.build());
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }
}

