/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.inject.Singleton;
import javax.net.ssl.SSLException;

@Requirements(value={@Requires(property="micronaut.ssl.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.ssl.build-self-signed", value="true", defaultValue="false")})
@Singleton
@Internal
public class SelfSignedSslBuilder
extends SslBuilder<SslContext>
implements ServerSslBuilder {
    public SelfSignedSslBuilder(ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super((SslConfiguration)ssl, resourceResolver);
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return (ServerSslConfiguration)this.ssl;
    }

    @Override
    public Optional<SslContext> build() {
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            return Optional.of(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build());
        }
        catch (CertificateException | SSLException e) {
            throw new SslConfigurationException("Encountered an error while building a self signed certificate", (Throwable)e);
        }
    }
}

