/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.types.files.StreamedFile;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;

public class NettyStreamedFileCustomizableResponseType
extends StreamedFile
implements NettyFileCustomizableResponseType {
    private final Optional<StreamedFile> delegate;

    public NettyStreamedFileCustomizableResponseType(InputStream inputStream, String name) {
        super(inputStream, MediaType.forFilename((String)name));
        this.delegate = Optional.empty();
    }

    public NettyStreamedFileCustomizableResponseType(InputStream inputStream, MediaType mediaType) {
        super(inputStream, mediaType);
        this.delegate = Optional.empty();
    }

    public NettyStreamedFileCustomizableResponseType(URL url) {
        super(url);
        this.delegate = Optional.empty();
    }

    public NettyStreamedFileCustomizableResponseType(StreamedFile delegate) {
        super(delegate.getInputStream(), delegate.getMediaType(), delegate.getLastModified(), delegate.getLength());
        this.delegate = Optional.of(delegate);
    }

    public void process(MutableHttpResponse response) {
        long length = this.getLength();
        if (length > -1L) {
            response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(length));
        } else {
            response.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
        }
        this.delegate.ifPresent(type -> type.process(response));
    }

    @Override
    public void write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        if (!(response instanceof NettyMutableHttpResponse)) {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
        FullHttpResponse nettyResponse = ((NettyMutableHttpResponse)response).getNativeResponse();
        context.write((Object)new DefaultHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), nettyResponse.headers()), context.voidPromise());
        context.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream(this.getInputStream())));
    }
}

