/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.net.URI;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
@Produces
public class UnsatisfiedRouteHandler
implements ExceptionHandler<UnsatisfiedRouteException, HttpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(UnsatisfiedRouteHandler.class);

    public HttpResponse handle(HttpRequest request, UnsatisfiedRouteException exception) {
        if (LOG.isErrorEnabled()) {
            LOG.error("{} (Bad Request): {}", (Object)request, (Object)exception.getMessage());
        }
        JsonError error = new JsonError(exception.getMessage());
        error.path('/' + exception.getArgument().getName());
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.badRequest((Object)error);
    }
}

