/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.server.netty.HttpDataReference;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

@Internal
public class NettyPartData
implements PartData {
    private final HttpDataReference httpData;
    private final HttpDataReference.Component component;

    public NettyPartData(HttpDataReference httpData, HttpDataReference.Component component) {
        this.httpData = httpData;
        this.component = component;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteBufInputStream(this.getByteBuf(), true);
    }

    public byte[] getBytes() throws IOException {
        ByteBuf byteBuf = this.getByteBuf();
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            byteBuf.release();
        }
    }

    public ByteBuffer getByteBuffer() throws IOException {
        ByteBuf byteBuf = this.getByteBuf();
        try {
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            return byteBuffer;
        }
        finally {
            byteBuf.release();
        }
    }

    public Optional<MediaType> getContentType() {
        return this.httpData.getContentType();
    }

    public ByteBuf getByteBuf() throws IOException {
        return this.component.getByteBuf();
    }
}

