/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.EpollAvailabilityCondition;
import io.micronaut.http.server.netty.EventLoopGroupFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(property="micronaut.server.netty.use-native-transport", value="true", defaultValue="false"), @Requires(classes={Epoll.class}, condition=EpollAvailabilityCondition.class)})
@Internal
class EpollEventLoopGroupFactory
implements EventLoopGroupFactory {
    EpollEventLoopGroupFactory() {
    }

    private static EpollEventLoopGroup withIoRatio(EpollEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return EpollEventLoopGroupFactory.withIoRatio(new EpollEventLoopGroup(threads), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return EpollEventLoopGroupFactory.withIoRatio(new EpollEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return EpollEventLoopGroupFactory.withIoRatio(new EpollEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(@Nullable Integer ioRatio) {
        return EpollEventLoopGroupFactory.withIoRatio(new EpollEventLoopGroup(), ioRatio);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return EpollServerSocketChannel.class;
    }
}

