/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.EpollEventLoopGroupFactory;
import io.micronaut.http.server.netty.EventLoopGroupFactory;
import io.micronaut.http.server.netty.KQueueEventLoopGroupFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@Internal
@Requires(missingBeans={EpollEventLoopGroupFactory.class, KQueueEventLoopGroupFactory.class})
public class NioEventLoopGroupFactory
implements EventLoopGroupFactory {
    private static NioEventLoopGroup withIoRatio(NioEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(@Nullable Integer ioRatio) {
        return NioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(), ioRatio);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NioServerSocketChannel.class;
    }
}

