/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.HttpServerConfiguration;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettyStreamingFileUpload
implements StreamingFileUpload {
    private static final Logger LOG = LoggerFactory.getLogger(NettyStreamingFileUpload.class);
    private FileUpload fileUpload;
    private final ExecutorService ioExecutor;
    private final HttpServerConfiguration.MultipartConfiguration configuration;
    private final Flowable subject;

    public NettyStreamingFileUpload(FileUpload httpData, HttpServerConfiguration.MultipartConfiguration multipartConfiguration, ExecutorService ioExecutor, Flowable subject) {
        this.configuration = multipartConfiguration;
        this.fileUpload = httpData;
        this.ioExecutor = ioExecutor;
        this.subject = subject;
    }

    public Optional<MediaType> getContentType() {
        try {
            return Optional.of(new MediaType(this.fileUpload.getContentType()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public long getDefinedSize() {
        return this.fileUpload.definedLength();
    }

    public boolean isComplete() {
        return this.fileUpload.isCompleted();
    }

    public Publisher<Boolean> transferTo(String location) {
        String baseDirectory = this.configuration.getLocation().map(File::getAbsolutePath).orElse(DiskFileUpload.baseDirectory);
        File file = baseDirectory == null ? this.createTemp(location) : new File(baseDirectory, location);
        return this.transferTo(file);
    }

    public Publisher<Boolean> transferTo(File destination) {
        final BooleanSupplier transferOperation = () -> {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transferring file {} to location {}", (Object)this.fileUpload.getFilename(), (Object)destination);
                }
                return destination != null && this.fileUpload.renameTo(destination);
            }
            catch (IOException e) {
                throw new MultipartException("Error transferring file: " + this.fileUpload.getName(), (Throwable)e);
            }
        };
        return Single.create(emitter -> this.subject.subscribeOn(Schedulers.from((Executor)this.ioExecutor)).subscribe(new Subscriber(){
            Subscription subscription;

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                this.subscription.request(1L);
            }

            public void onNext(Object o) {
                this.subscription.request(1L);
            }

            public void onError(Throwable t) {
                emitter.onError(t);
            }

            public void onComplete() {
                if (NettyStreamingFileUpload.this.fileUpload.isCompleted()) {
                    try {
                        emitter.onSuccess((Object)transferOperation.getAsBoolean());
                    }
                    catch (Exception e) {
                        emitter.onError((Throwable)e);
                    }
                } else {
                    emitter.onError((Throwable)new MultipartException("Transfer did not complete"));
                }
            }
        })).toFlowable();
    }

    public Publisher<Boolean> delete() {
        return new AsyncSingleResultPublisher(this.ioExecutor, () -> {
            this.fileUpload.delete();
            return true;
        });
    }

    protected File createTemp(String location) {
        File tempFile;
        try {
            tempFile = File.createTempFile("FUp_", ".tmp_" + location);
        }
        catch (IOException e) {
            throw new MultipartException("Unable to create temp directory: " + e.getMessage(), (Throwable)e);
        }
        if (tempFile.delete()) {
            return tempFile;
        }
        return null;
    }

    public void subscribe(Subscriber<? super PartData> s) {
        this.subject.subscribe(s);
    }
}

