/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.inject.Singleton;
import javax.net.ssl.SSLException;

@Requirements(value={@Requires(property="micronaut.ssl.enabled", value="true", defaultValue="false"), @Requires(property="micronaut.ssl.build-self-signed", value="true", defaultValue="false")})
@Singleton
@Internal
public class SelfSignedSslBuilder
extends SslBuilder<SslContext>
implements ServerSslBuilder {
    private final ServerSslConfiguration ssl;
    private final HttpServerConfiguration serverConfiguration;

    public SelfSignedSslBuilder(HttpServerConfiguration serverConfiguration, ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super(resourceResolver);
        this.ssl = ssl;
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public ServerSslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public Optional<SslContext> build() {
        return this.build((SslConfiguration)this.ssl);
    }

    public Optional<SslContext> build(SslConfiguration ssl) {
        HttpVersion httpVersion = this.serverConfiguration.getHttpVersion();
        return this.build(ssl, httpVersion);
    }

    public Optional<SslContext> build(SslConfiguration ssl, HttpVersion httpVersion) {
        try {
            boolean isHttp2;
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            SslContextBuilder sslBuilder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
            boolean bl = isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
            if (isHttp2) {
                SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
                sslBuilder.sslProvider(provider);
                sslBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                sslBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
            }
            return Optional.of(sslBuilder.build());
        }
        catch (CertificateException | SSLException e) {
            throw new SslConfigurationException("Encountered an error while building a self signed certificate", (Throwable)e);
        }
    }
}

