/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Provider;

@Deprecated
public class FileUploadToObjectConverter
implements TypeConverter<FileUpload, Object> {
    private final ConversionService conversionService;
    private final Provider<MediaTypeCodecRegistry> decoderRegistryProvider;

    protected FileUploadToObjectConverter(ConversionService conversionService, Provider<MediaTypeCodecRegistry> decoderRegistryProvider) {
        this.conversionService = conversionService;
        this.decoderRegistryProvider = decoderRegistryProvider;
    }

    public Optional<Object> convert(FileUpload object, Class<Object> targetType, ConversionContext context) {
        try {
            if (!object.isCompleted()) {
                return Optional.empty();
            }
            String contentType = object.getContentType();
            ByteBuf byteBuf = object.getByteBuf();
            if (StringUtils.isNotEmpty((CharSequence)contentType)) {
                MediaType mediaType = MediaType.of((String)contentType);
                Optional registered = ((MediaTypeCodecRegistry)this.decoderRegistryProvider.get()).findCodec(mediaType);
                if (registered.isPresent()) {
                    MediaTypeCodec decoder = (MediaTypeCodec)registered.get();
                    Object val = decoder.decode(targetType, (InputStream)new ByteBufInputStream(byteBuf));
                    return Optional.of(val);
                }
                return this.conversionService.convert((Object)byteBuf, targetType, context);
            }
            return this.conversionService.convert((Object)byteBuf, targetType, context);
        }
        catch (Exception e) {
            context.reject(e);
            return Optional.empty();
        }
    }
}

