/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.HttpServerConfiguration;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
public class NettyStreamingFileUpload
implements StreamingFileUpload {
    private static final Logger LOG = LoggerFactory.getLogger(NettyStreamingFileUpload.class);
    private FileUpload fileUpload;
    private final ExecutorService ioExecutor;
    private final HttpServerConfiguration.MultipartConfiguration configuration;
    private final Flux<PartData> subject;

    public NettyStreamingFileUpload(FileUpload httpData, HttpServerConfiguration.MultipartConfiguration multipartConfiguration, ExecutorService ioExecutor, Flux<PartData> subject) {
        this.configuration = multipartConfiguration;
        this.fileUpload = httpData;
        this.ioExecutor = ioExecutor;
        this.subject = subject;
    }

    public Optional<MediaType> getContentType() {
        return Optional.of(new MediaType(this.fileUpload.getContentType(), NameUtils.extension((String)this.fileUpload.getFilename())));
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public long getDefinedSize() {
        return this.fileUpload.definedLength();
    }

    public boolean isComplete() {
        return this.fileUpload.isCompleted();
    }

    public Publisher<Boolean> transferTo(String location) {
        String baseDirectory = this.configuration.getLocation().map(File::getAbsolutePath).orElse(DiskFileUpload.baseDirectory);
        File file = baseDirectory == null ? this.createTemp(location) : new File(baseDirectory, location);
        return this.transferTo(file);
    }

    public Publisher<Boolean> transferTo(final File destination) {
        return Mono.create(emitter -> this.subject.subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.ioExecutor)).subscribe((Subscriber)new Subscriber<PartData>(){
            Subscription subscription;
            OutputStream outputStream;

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                this.subscription.request(1L);
                try {
                    this.outputStream = Files.newOutputStream(destination.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }

            public void onNext(PartData o) {
                try {
                    this.outputStream.write(o.getBytes());
                    this.subscription.request(1L);
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }

            public void onError(Throwable t) {
                block3: {
                    emitter.error(t);
                    try {
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) break block3;
                        LOG.warn("Failed to close file stream : " + NettyStreamingFileUpload.this.fileUpload.getName());
                    }
                }
            }

            public void onComplete() {
                try {
                    this.outputStream.close();
                    emitter.success((Object)true);
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Failed to close file stream : " + NettyStreamingFileUpload.this.fileUpload.getName());
                    }
                    emitter.success((Object)false);
                }
            }

            private void handleError(Throwable t) {
                this.subscription.cancel();
                this.onError((Throwable)new MultipartException("Error transferring file: " + NettyStreamingFileUpload.this.fileUpload.getName(), t));
            }
        })).flux();
    }

    public Publisher<Boolean> delete() {
        return new AsyncSingleResultPublisher(this.ioExecutor, () -> {
            this.fileUpload.delete();
            return true;
        });
    }

    protected File createTemp(String location) {
        File tempFile;
        try {
            tempFile = Files.createTempFile("FUp_", ".tmp_" + location, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MultipartException("Unable to create temp directory: " + e.getMessage(), (Throwable)e);
        }
        if (tempFile.delete()) {
            return tempFile;
        }
        return null;
    }

    public void subscribe(Subscriber<? super PartData> s) {
        this.subject.subscribe(s);
    }

    public void discard() {
        this.fileUpload.release();
    }
}

