/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class DefaultCustomizableResponseTypeHandlerRegistry
implements NettyCustomizableResponseTypeHandlerRegistry {
    private List<NettyCustomizableResponseTypeHandler> handlers;
    private ConcurrentHashMap<Class<?>, Optional<NettyCustomizableResponseTypeHandler>> handlerCache = new ConcurrentHashMap(5);

    public DefaultCustomizableResponseTypeHandlerRegistry(NettyCustomizableResponseTypeHandler ... typeHandlers) {
        this.handlers = Arrays.asList(typeHandlers);
    }

    @Inject
    public DefaultCustomizableResponseTypeHandlerRegistry(List<NettyCustomizableResponseTypeHandler> typeHandlers) {
        this.handlers = CollectionUtils.isNotEmpty(typeHandlers) ? typeHandlers : Collections.emptyList();
    }

    @Override
    public Optional<NettyCustomizableResponseTypeHandler> findTypeHandler(Class<?> type) {
        Optional<NettyCustomizableResponseTypeHandler> foundHandler = this.handlerCache.get(type);
        if (foundHandler != null) {
            return foundHandler;
        }
        Optional<NettyCustomizableResponseTypeHandler> optionalHandler = Optional.empty();
        for (NettyCustomizableResponseTypeHandler handler : this.handlers) {
            if (!handler.supports(type)) continue;
            optionalHandler = Optional.of(handler);
            break;
        }
        this.handlerCache.put(type, optionalHandler);
        return optionalHandler;
    }
}

