/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.MicronautHttpPostMultipartRequestDecoder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class FormDataHttpContentProcessor
extends AbstractHttpContentProcessor<HttpData> {
    private final InterfaceHttpPostRequestDecoder decoder;
    private final boolean enabled;
    private AtomicLong extraMessages = new AtomicLong(0L);
    private final long partMaxSize;

    FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        DefaultHttpDataFactory factory = multipart.isDisk() ? new DefaultHttpDataFactory(true, characterEncoding) : (multipart.isMixed() ? new DefaultHttpDataFactory(multipart.getThreshold(), characterEncoding) : new DefaultHttpDataFactory(false, characterEncoding));
        factory.setMaxLimit(multipart.getMaxFileSize());
        HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
        this.decoder = HttpPostRequestDecoder.isMultipart((HttpRequest)nativeRequest) ? new MicronautHttpPostMultipartRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding) : new HttpPostStandardRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding);
        this.enabled = nettyHttpRequest.getContentType().map(type -> type.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)).orElse(false) != false || multipart.isEnabled();
        this.partMaxSize = multipart.getMaxFileSize();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void doOnSubscribe(final Subscription subscription, Subscriber<? super HttpData> subscriber) {
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                FormDataHttpContentProcessor.this.extraMessages.updateAndGet(p -> {
                    long newVal = p - n;
                    if (newVal < 0L) {
                        subscription.request(n - p);
                        return 0L;
                    }
                    return newVal;
                });
            }

            public void cancel() {
                subscription.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onData(ByteBufHolder message) {
        Subscriber subscriber = this.getSubscriber();
        if (message instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)message;
            ArrayList<Object> messages = new ArrayList<Object>(1);
            try {
                InterfaceHttpPostRequestDecoder postRequestDecoder = this.decoder;
                postRequestDecoder.offer(httpContent);
                while (postRequestDecoder.hasNext()) {
                    InterfaceHttpData data = postRequestDecoder.next();
                    switch (data.getHttpDataType()) {
                        case Attribute: {
                            Attribute attribute = (Attribute)data;
                            messages.add(attribute);
                            postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)attribute);
                            break;
                        }
                        case FileUpload: {
                            FileUpload fileUpload = (FileUpload)data;
                            if (!fileUpload.isCompleted()) break;
                            messages.add(fileUpload);
                            postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)fileUpload);
                            break;
                        }
                    }
                }
                InterfaceHttpData currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                if (!(currentPartialHttpData instanceof HttpData)) return;
                messages.add(currentPartialHttpData);
                return;
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException postRequestDecoder) {
                return;
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException && cause.getMessage().equals("Size exceed allowed maximum capacity")) {
                    String partName = this.decoder.currentPartialHttpData().getName();
                    try {
                        this.onError((Throwable)new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]"));
                        return;
                    }
                    finally {
                        this.parentSubscription.cancel();
                    }
                }
                this.onError(e);
                return;
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
            finally {
                if (messages.isEmpty()) {
                    this.subscription.request(1L);
                } else {
                    this.extraMessages.updateAndGet(p -> p + (long)messages.size() - 1L);
                    messages.stream().map(HttpData.class::cast).forEach(arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
                }
                httpContent.release();
            }
        } else {
            message.release();
        }
    }

    protected void doAfterOnError(Throwable throwable) {
        this.decoder.destroy();
    }

    protected void doAfterComplete() {
        this.decoder.destroy();
    }
}

