/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpDataReference;
import io.micronaut.http.server.netty.IdentityWrapper;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;

@Internal
@ChannelHandler.Sharable
class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    private static final Argument ARGUMENT_PART_DATA = Argument.of(PartData.class);
    private final Router router;
    private final StaticResourceResolver staticResourceResolver;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final ErrorResponseProcessor<?> errorResponseProcessor;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    private final Supplier<ExecutorService> ioExecutorSupplier;
    private final boolean multipartEnabled;
    private ExecutorService ioExecutor;
    private final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    private final RouteExecutor routeExecutor;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher) {
        this.mediaTypeCodecRegistry = embeddedServerContext.getMediaTypeCodecRegistry();
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.ioExecutorSupplier = ioExecutor;
        this.router = embeddedServerContext.getRouter();
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.errorResponseProcessor = embeddedServerContext.getRouteExecutor().getErrorResponseProcessor();
        this.terminateEventPublisher = terminateEventPublisher;
        Optional multipartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = !multipartEnabled.isPresent() || (Boolean)multipartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanupIfNecessary(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        this.cleanupIfNecessary(ctx);
    }

    private void cleanupIfNecessary(ChannelHandlerContext ctx) {
        NettyHttpRequest.remove(ctx);
    }

    private void cleanupRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        try {
            request.release();
        }
        finally {
            if (this.terminateEventPublisher != ApplicationEventPublisher.NO_OP) {
                ctx.executor().execute(() -> {
                    block2: {
                        try {
                            this.terminateEventPublisher.publishEvent((Object)new HttpRequestTerminatedEvent((HttpRequest)request));
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block2;
                            LOG.error("Error publishing request terminated event: " + e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
            return;
        }
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        if (nettyHttpRequest == null) {
            if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        ServerRequestContext.set((HttpRequest)nettyHttpRequest);
        this.filterAndEncodeResponse(ctx, nettyHttpRequest, (Publisher<MutableHttpResponse<?>>)this.routeExecutor.onError(cause, (HttpRequest)nettyHttpRequest));
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> request) {
        NettyHttpRequest nettyHttpRequest;
        io.netty.handler.codec.http.HttpRequest nativeRequest;
        DecoderResult decoderResult;
        ctx.channel().config().setAutoRead(false);
        HttpMethod httpMethod = request.getMethod();
        String requestPath = request.getUri().getPath();
        ServerRequestContext.set(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request {} {}", (Object)httpMethod, (Object)request.getUri());
        }
        if ((decoderResult = (nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()).decoderResult()).isFailure()) {
            Throwable cause = decoderResult.cause();
            HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)status), status.getReason());
            return;
        }
        MediaType contentType = request.getContentType().orElse(null);
        String requestMethodName = request.getMethodName();
        if (!this.multipartEnabled && contentType != null && contentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Multipart uploads have been disabled via configuration. Rejected request for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
            }
            this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed");
            return;
        }
        UriRouteMatch routeMatch = null;
        List uriRoutes = this.router.findAllClosest(request);
        if (uriRoutes.size() > 1) {
            throw new DuplicateRouteException(requestPath, uriRoutes);
        }
        if (uriRoutes.size() == 1) {
            UriRouteMatch establishedRoute = (UriRouteMatch)uriRoutes.get(0);
            request.setAttribute((CharSequence)HttpAttributes.ROUTE, (Object)establishedRoute.getRoute());
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)establishedRoute);
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_INFO, (Object)establishedRoute);
            request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)establishedRoute.getRoute().getUriMatchTemplate().toString());
            routeMatch = establishedRoute;
        }
        if (routeMatch == null) {
            Optional<? extends FileCustomizableResponseType> optionalFile = this.matchFile(requestPath);
            if (optionalFile.isPresent()) {
                this.filterAndEncodeResponse(ctx, nettyHttpRequest, (Publisher<MutableHttpResponse<?>>)Flux.just((Object)HttpResponse.ok((Object)optionalFile.get())));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No matching route: {} {}", (Object)httpMethod, (Object)request.getUri());
            }
            List anyMatchingRoutes = this.router.findAny((CharSequence)request.getUri().toString(), request).collect(Collectors.toList());
            Collection acceptedTypes = request.accept();
            boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)acceptedTypes);
            HashSet acceptableContentTypes = contentType != null ? new HashSet(5) : null;
            HashSet<String> allowedMethods = new HashSet<String>(5);
            HashSet produceableContentTypes = hasAcceptHeader ? new HashSet(5) : null;
            for (UriRouteMatch anyRoute : anyMatchingRoutes) {
                String routeMethod = anyRoute.getRoute().getHttpMethodName();
                if (!requestMethodName.equals(routeMethod)) {
                    allowedMethods.add(routeMethod);
                }
                if (contentType != null && !anyRoute.doesConsume(contentType)) {
                    acceptableContentTypes.addAll(anyRoute.getRoute().getConsumes());
                }
                if (!hasAcceptHeader || anyRoute.doesProduce(acceptedTypes)) continue;
                produceableContentTypes.addAll(anyRoute.getRoute().getProduces());
            }
            if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
                }
                this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
                return;
            }
            if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
                }
                this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
                return;
            }
            if (!allowedMethods.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method not allowed for URI {} and method {}", (Object)request.getUri(), (Object)requestMethodName);
                }
                this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + request.getUri() + "]. Allowed methods: " + allowedMethods);
                return;
            }
            this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)HttpStatus.NOT_FOUND), "Page Not Found");
            return;
        }
        UriRouteMatch route = routeMatch;
        if (LOG.isTraceEnabled()) {
            if (route instanceof MethodBasedRouteMatch) {
                LOG.trace("Matched route {} - {} to controller {}", new Object[]{requestMethodName, requestPath, route.getDeclaringType()});
            } else {
                LOG.trace("Matched route {} - {}", (Object)requestMethodName, (Object)requestPath);
            }
        }
        if (route.isWebSocketRoute()) {
            this.handleStatusError(ctx, nettyHttpRequest, HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST), "Not a WebSocket request");
        } else {
            this.handleRouteMatch((RouteMatch<?>)route, nettyHttpRequest, ctx);
        }
    }

    private void handleStatusError(ChannelHandlerContext ctx, NettyHttpRequest<?> nettyHttpRequest, MutableHttpResponse<?> defaultResponse, String message) {
        Optional statusRoute = this.router.findStatusRoute(defaultResponse.status(), nettyHttpRequest);
        if (statusRoute.isPresent()) {
            RouteMatch routeMatch = (RouteMatch)statusRoute.get();
            this.handleRouteMatch(routeMatch, nettyHttpRequest, ctx);
        } else {
            if (nettyHttpRequest.getMethod() != HttpMethod.HEAD && !(defaultResponse = this.errorResponseProcessor.processResponse(ErrorContext.builder(nettyHttpRequest).errorMessage(message).build(), defaultResponse)).getContentType().isPresent()) {
                defaultResponse = defaultResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
            }
            this.filterAndEncodeResponse(ctx, nettyHttpRequest, Publishers.just(defaultResponse));
        }
    }

    private void filterAndEncodeResponse(final ChannelHandlerContext channelContext, final NettyHttpRequest<?> request, Publisher<MutableHttpResponse<?>> responsePublisher) {
        AtomicReference requestReference = new AtomicReference(request);
        Flux.from((Publisher)this.routeExecutor.filterPublisher(requestReference, responsePublisher)).contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)request)).subscribe(new Subscriber<MutableHttpResponse<?>>(){
            Subscription subscription;
            AtomicBoolean empty = new AtomicBoolean();

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            public void onNext(MutableHttpResponse<?> response) {
                this.empty.set(false);
                RoutingInBoundHandler.this.encodeHttpResponse(channelContext, request, response, (Argument<Object>)null, response.body());
                this.subscription.request(1L);
            }

            public void onError(Throwable t) {
                this.empty.set(false);
                MutableHttpResponse response = RoutingInBoundHandler.this.routeExecutor.createDefaultErrorResponse((HttpRequest)request, t);
                RoutingInBoundHandler.this.encodeHttpResponse(channelContext, request, response, (Argument<Object>)null, response.body());
            }

            public void onComplete() {
                if (this.empty.get()) {
                    channelContext.read();
                }
            }
        });
    }

    private Optional<? extends FileCustomizableResponseType> matchFile(String path) {
        Optional optionalUrl = this.staticResourceResolver.resolve(path);
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = (URL)optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return Optional.of(new NettySystemFileCustomizableResponseType(file));
                }
                return Optional.of(new NettyStreamedFileCustomizableResponseType(url));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private void handleRouteMatch(RouteMatch<?> originalRoute, final NettyHttpRequest<?> request, final ChannelHandlerContext context) {
        Flux routeMatchPublisher;
        final RouteMatch route = this.requestArgumentSatisfier.fulfillArgumentRequirements(originalRoute, request, false);
        Optional<Argument> bodyArgument = route.getBodyArgument().filter(argument -> argument.getAnnotationMetadata().hasAnnotation(Body.class));
        io.netty.handler.codec.http.HttpRequest nativeRequest = request.getNativeRequest();
        if (!(route.isExecutable() || !HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) || !(nativeRequest instanceof StreamedHttpRequest) || bodyArgument.isPresent() && route.isSatisfied(bodyArgument.get().getName()))) {
            routeMatchPublisher = Mono.create(emitter -> this.httpContentProcessorResolver.resolve(request, route).subscribe(this.buildSubscriber(request, (RouteMatch<?>)route, (MonoSink<RouteMatch<?>>)emitter))).flux();
        } else {
            context.read();
            routeMatchPublisher = Flux.just((Object)route);
        }
        Flux routeResponse = this.routeExecutor.executeRoute(request, true, routeMatchPublisher);
        routeResponse.contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)request)).subscribe((Subscriber)new CompletionAwareSubscriber<HttpResponse<?>>(){

            protected void doOnSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            protected void doOnNext(HttpResponse<?> message) {
                RoutingInBoundHandler.this.encodeHttpResponse(context, request, RoutingInBoundHandler.this.toMutableResponse(message), (Argument<Object>)route.getBodyType(), message.body());
                this.subscription.request(1L);
            }

            protected void doOnError(Throwable throwable) {
                MutableHttpResponse defaultErrorResponse = RoutingInBoundHandler.this.routeExecutor.createDefaultErrorResponse((HttpRequest)request, throwable);
                RoutingInBoundHandler.this.encodeHttpResponse(context, request, defaultErrorResponse, (Argument<Object>)route.getBodyType(), defaultErrorResponse.body());
            }

            protected void doOnComplete() {
            }
        });
    }

    private Subscriber<Object> buildSubscriber(final NettyHttpRequest<?> request, final RouteMatch<?> finalRoute, final MonoSink<RouteMatch<?>> emitter) {
        boolean isFormData = request.isFormOrMultipartData();
        if (isFormData) {
            return new CompletionAwareSubscriber<Object>(){
                final boolean alwaysAddContent;
                RouteMatch<?> routeMatch;
                final AtomicBoolean executed;
                final AtomicLong pressureRequested;
                final ConcurrentHashMap<String, Sinks.Many<Object>> subjectsByDataName;
                final Collection<Sinks.Many<Object>> downstreamSubscribers;
                final ConcurrentHashMap<IdentityWrapper, HttpDataReference> dataReferences;
                final ConversionService conversionService;
                Subscription s;
                final LongConsumer onRequest;
                {
                    this.alwaysAddContent = request.isFormData();
                    this.routeMatch = finalRoute;
                    this.executed = new AtomicBoolean(false);
                    this.pressureRequested = new AtomicLong(0L);
                    this.subjectsByDataName = new ConcurrentHashMap();
                    this.downstreamSubscribers = Collections.synchronizedList(new ArrayList());
                    this.dataReferences = new ConcurrentHashMap();
                    this.conversionService = ConversionService.SHARED;
                    this.onRequest = num -> this.pressureRequested.updateAndGet(p -> {
                        long newVal = p - num;
                        if (newVal < 0L) {
                            this.s.request(num - p);
                            return 0L;
                        }
                        return newVal;
                    });
                }

                Flux processFlowable(Sinks.Many<Object> many, HttpDataReference dataReference, boolean controlsFlow) {
                    Flux flux = many.asFlux();
                    if (controlsFlow) {
                        flux = flux.doOnRequest(this.onRequest);
                    }
                    return flux.doAfterTerminate(() -> {
                        if (controlsFlow) {
                            dataReference.destroy();
                        }
                    });
                }

                protected void doOnSubscribe(Subscription subscription) {
                    this.s = subscription;
                    subscription.request(1L);
                }

                protected void doOnNext(Object message) {
                    try {
                        this.doOnNext0(message);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)message);
                    }
                }

                private void doOnNext0(Object message) {
                    if (request.destroyed) {
                        return;
                    }
                    boolean executed = this.executed.get();
                    if (message instanceof ByteBufHolder) {
                        if (message instanceof HttpData) {
                            String name;
                            Optional requiredInput;
                            HttpData data = (HttpData)message;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Received HTTP Data for request [{}]: {}", (Object)request, message);
                            }
                            if ((requiredInput = this.routeMatch.getRequiredInput(name = data.getName())).isPresent()) {
                                Supplier<Object> value;
                                Argument argument = (Argument)requiredInput.get();
                                boolean isPublisher = Publishers.isConvertibleToPublisher((Class)argument.getType());
                                boolean chunkedProcessing = false;
                                if (isPublisher) {
                                    Sinks.Many ds;
                                    HttpDataReference dataReference = this.dataReferences.computeIfAbsent(new IdentityWrapper(data), key -> new HttpDataReference(data));
                                    Argument typeVariable = StreamingFileUpload.class.isAssignableFrom(argument.getType()) ? ARGUMENT_PART_DATA : argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                    Class typeVariableType = typeVariable.getType();
                                    Sinks.Many namedSubject = this.subjectsByDataName.computeIfAbsent(name, key -> this.makeDownstreamUnicastProcessor());
                                    boolean bl = chunkedProcessing = PartData.class.equals((Object)typeVariableType) || Publishers.isConvertibleToPublisher((Class)typeVariableType) || ClassUtils.isJavaLangType((Class)typeVariableType);
                                    if (Publishers.isConvertibleToPublisher((Class)typeVariableType)) {
                                        boolean streamingFileUpload = StreamingFileUpload.class.isAssignableFrom(typeVariableType);
                                        typeVariable = streamingFileUpload ? ARGUMENT_PART_DATA : typeVariable.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                        dataReference.subject.getAndUpdate(subject -> {
                                            if (subject == null) {
                                                Sinks.Many<Object> childSubject = this.makeDownstreamUnicastProcessor();
                                                Flux flowable = this.processFlowable(childSubject, dataReference, true);
                                                if (streamingFileUpload && data instanceof FileUpload) {
                                                    namedSubject.tryEmitNext((Object)new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), (Flux<PartData>)flowable));
                                                } else {
                                                    namedSubject.tryEmitNext((Object)flowable);
                                                }
                                                return childSubject;
                                            }
                                            return subject;
                                        });
                                    }
                                    Sinks.Many subject2 = (ds = dataReference.subject.get()) != null ? ds : namedSubject;
                                    Object part = data;
                                    if (chunkedProcessing) {
                                        HttpDataReference.Component component;
                                        try {
                                            component = dataReference.addComponent();
                                            if (component == null) {
                                                this.s.request(1L);
                                                return;
                                            }
                                        }
                                        catch (IOException e) {
                                            subject2.tryEmitError((Throwable)e);
                                            this.s.cancel();
                                            return;
                                        }
                                        part = new NettyPartData(dataReference, component);
                                    }
                                    if (data instanceof FileUpload && StreamingFileUpload.class.isAssignableFrom(argument.getType())) {
                                        dataReference.upload.getAndUpdate(upload -> {
                                            if (upload == null) {
                                                return new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), (Flux<PartData>)this.processFlowable((Sinks.Many<Object>)subject2, dataReference, true));
                                            }
                                            return upload;
                                        });
                                    }
                                    Optional converted = this.conversionService.convert(part, typeVariable);
                                    converted.ifPresent(arg_0 -> ((Sinks.Many)subject2).tryEmitNext(arg_0));
                                    if (data.isCompleted() && chunkedProcessing) {
                                        subject2.tryEmitComplete();
                                    }
                                    value = () -> {
                                        StreamingFileUpload upload = dataReference.upload.get();
                                        if (upload != null) {
                                            return upload;
                                        }
                                        return this.processFlowable((Sinks.Many<Object>)namedSubject, dataReference, dataReference.subject.get() == null);
                                    };
                                } else {
                                    if (data instanceof Attribute && !data.isCompleted()) {
                                        request.addContent((ByteBufHolder)data);
                                        this.s.request(1L);
                                        return;
                                    }
                                    value = () -> {
                                        if (data.refCnt() > 0) {
                                            return data;
                                        }
                                        return null;
                                    };
                                }
                                if (!executed) {
                                    String argumentName = argument.getName();
                                    if (!this.routeMatch.isSatisfied(argumentName)) {
                                        Object fulfillParamter = value.get();
                                        this.routeMatch = this.routeMatch.fulfill(Collections.singletonMap(argumentName, fulfillParamter));
                                        if (!this.alwaysAddContent && fulfillParamter instanceof ByteBufHolder) {
                                            request.addContent((ByteBufHolder)fulfillParamter);
                                        }
                                    }
                                    if (isPublisher && chunkedProcessing) {
                                        this.pressureRequested.incrementAndGet();
                                    }
                                    if (this.routeMatch.isExecutable() || message instanceof LastHttpContent) {
                                        this.executeRoute();
                                        executed = true;
                                    }
                                }
                                if (this.alwaysAddContent && !request.destroyed) {
                                    request.addContent((ByteBufHolder)data);
                                }
                                if (!executed || !chunkedProcessing) {
                                    this.s.request(1L);
                                }
                            } else {
                                request.addContent((ByteBufHolder)data);
                                this.s.request(1L);
                            }
                        } else {
                            request.addContent((ByteBufHolder)message);
                            this.s.request(1L);
                        }
                    } else {
                        request.setBody(message);
                        this.s.request(1L);
                    }
                }

                protected void doOnError(Throwable t) {
                    this.s.cancel();
                    for (Object v : this.routeMatch.getVariableValues().values()) {
                        if (v instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                            ((io.micronaut.core.io.buffer.ReferenceCounted)v).release();
                        }
                        if (v instanceof ReferenceCounted) {
                            ((ReferenceCounted)v).release();
                        }
                        if (!(v instanceof NettyCompletedFileUpload)) continue;
                        ((NettyCompletedFileUpload)v).discard();
                    }
                    for (Sinks.Many many : this.downstreamSubscribers) {
                        many.tryEmitError(t);
                    }
                    emitter.error(t);
                }

                protected void doOnComplete() {
                    for (Sinks.Many<Object> subject : this.downstreamSubscribers) {
                        subject.tryEmitComplete();
                    }
                    this.executeRoute();
                }

                private Sinks.Many<Object> makeDownstreamUnicastProcessor() {
                    Sinks.Many processor = Sinks.many().unicast().onBackpressureBuffer();
                    this.downstreamSubscribers.add((Sinks.Many<Object>)processor);
                    return processor;
                }

                private void executeRoute() {
                    if (this.executed.compareAndSet(false, true)) {
                        emitter.success(this.routeMatch);
                    }
                }
            };
        }
        return new CompletionAwareSubscriber<Object>(){
            private Subscription s;
            private RouteMatch<?> routeMatch;
            private AtomicBoolean executed;
            {
                this.routeMatch = finalRoute;
                this.executed = new AtomicBoolean(false);
            }

            protected void doOnSubscribe(Subscription subscription) {
                this.s = subscription;
                subscription.request(1L);
            }

            protected void doOnNext(Object message) {
                if (message instanceof ByteBufHolder) {
                    request.addContent((ByteBufHolder)message);
                    this.s.request(1L);
                } else {
                    request.setBody(message);
                    this.s.request(1L);
                }
                ReferenceCountUtil.release((Object)message);
            }

            protected void doOnError(Throwable t) {
                this.s.cancel();
                emitter.error(t);
            }

            protected void doOnComplete() {
                if (this.executed.compareAndSet(false, true)) {
                    emitter.success(this.routeMatch);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(ChannelHandlerContext context, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body) {
        boolean isNotHead;
        boolean bl = isNotHead = nettyRequest.getMethod() != HttpMethod.HEAD;
        if (isNotHead) {
            if (body instanceof Writable) {
                this.getIoExecutor().execute(() -> {
                    ByteBuf byteBuf = context.alloc().ioBuffer(128);
                    ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                    try {
                        Writable writable = (Writable)body;
                        writable.writeTo((OutputStream)outputStream, nettyRequest.getCharacterEncoding());
                        response.body((Object)byteBuf);
                        if (!response.getContentType().isPresent()) {
                            response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).ifPresent(routeInfo -> response.contentType(this.routeExecutor.resolveDefaultResponseContentType((HttpRequest)nettyRequest, routeInfo)));
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }
                    catch (IOException e) {
                        MutableHttpResponse errorResponse = this.routeExecutor.createDefaultErrorResponse((HttpRequest)nettyRequest, (Throwable)e);
                        this.writeFinalNettyResponse(errorResponse, nettyRequest, context);
                    }
                });
            } else if (body instanceof Publisher) {
                response.body(null);
                DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse((HttpResponse<?>)response), (Publisher<HttpContent>)this.mapToHttpContent(nettyRequest, response, body, context));
                nettyRequest.prepareHttp2ResponseIfNecessary(streamedResponse);
                context.writeAndFlush((Object)streamedResponse);
                context.read();
            } else {
                this.encodeResponseBody(context, nettyRequest, response, bodyType, body);
                this.writeFinalNettyResponse(response, nettyRequest, context);
            }
        } else {
            response.body(null);
            this.writeFinalNettyResponse(response, nettyRequest, context);
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, ChannelHandlerContext context) {
        RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        boolean hasRouteInfo = routeInfo != null;
        MediaType mediaType = response.getContentType().orElse(null);
        if (mediaType == null && hasRouteInfo) {
            mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
        }
        boolean isJson = mediaType != null && mediaType.getExtension().equals("json") && this.isJsonFormattable(hasRouteInfo ? routeInfo.getBodyType() : null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux bodyPublisher = Flux.from((Publisher)((Publisher)Publishers.convertPublisher((Object)body, Publisher.class)));
        MediaType finalMediaType = mediaType;
        Flux httpContentPublisher = bodyPublisher.map(message -> {
            DefaultHttpContent httpContent;
            if (message instanceof ByteBuf) {
                httpContent = new DefaultHttpContent((ByteBuf)message);
            } else if (message instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)message;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                httpContent = nativeBuffer instanceof ByteBuf ? new DefaultHttpContent((ByteBuf)nativeBuffer) : new DefaultHttpContent(Unpooled.copiedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer()));
            } else if (message instanceof byte[]) {
                httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((byte[])((byte[])message)));
            } else if (message instanceof HttpContent) {
                httpContent = (HttpContent)message;
            } else {
                Argument bodyType;
                MediaTypeCodec codec = (MediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(finalMediaType, message.getClass()).orElse(new TextPlainCodec(this.serverConfiguration.getDefaultCharset()));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                }
                ByteBuffer encoded = hasRouteInfo ? ((bodyType = routeInfo.getBodyType()).isInstance(message) ? codec.encode(bodyType, message, (ByteBufferFactory)byteBufferFactory) : codec.encode(message, (ByteBufferFactory)byteBufferFactory)) : codec.encode(message, (ByteBufferFactory)byteBufferFactory);
                httpContent = new DefaultHttpContent((ByteBuf)encoded.asNativeBuffer());
            }
            return httpContent;
        });
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift((Publisher)httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put((Object)"micronaut.http.server.request", (Object)request)).doOnNext(httpContent -> context.read()).doAfterTerminate(() -> this.cleanupRequest(context, request));
        return httpContentPublisher;
    }

    private boolean isJsonFormattable(Argument<?> argument) {
        if (argument == null) {
            return false;
        }
        Class javaType = argument.getType();
        if (Publishers.isConvertibleToPublisher((Class)javaType)) {
            javaType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType();
        }
        return javaType != byte[].class && !ByteBuffer.class.isAssignableFrom(javaType) && !ByteBuf.class.isAssignableFrom(javaType);
    }

    private void encodeResponseBody(ChannelHandlerContext context, HttpRequest<?> request, MutableHttpResponse<?> message, @Nullable Argument<Object> bodyType, Object body) {
        if (body == null) {
            return;
        }
        Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
        if (typeHandler.isPresent()) {
            NettyCustomizableResponseTypeHandler th = typeHandler.get();
            this.setBodyContent(message, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
        } else {
            MediaType mediaType = message.getContentType().orElse(null);
            if (mediaType == null) {
                mediaType = message.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).map(routeInfo -> this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo)).orElse(MediaType.APPLICATION_JSON_TYPE);
                message.contentType(mediaType);
            }
            if (body instanceof CharSequence) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])body.toString().getBytes(message.getCharacterEncoding()));
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof byte[]) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)body;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                if (nativeBuffer instanceof ByteBuf) {
                    this.setResponseBody(message, (ByteBuf)nativeBuffer);
                } else if (nativeBuffer instanceof java.nio.ByteBuffer) {
                    ByteBuf byteBuf = Unpooled.wrappedBuffer((java.nio.ByteBuffer)((java.nio.ByteBuffer)nativeBuffer));
                    this.setResponseBody(message, byteBuf);
                }
            } else if (body instanceof ByteBuf) {
                this.setResponseBody(message, (ByteBuf)body);
            } else {
                Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(mediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    this.encodeBodyWithCodec(message, bodyType, body, codec, context, request);
                } else {
                    TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset());
                    this.encodeBodyWithCodec(message, bodyType, body, (MediaTypeCodec)defaultCodec, context, request);
                }
            }
        }
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, final HttpRequest<?> request, final ChannelHandlerContext context) {
        HttpStatus httpStatus = message.status();
        HttpVersion httpVersion = request.getHttpVersion();
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        boolean decodeError = request instanceof NettyHttpRequest && ((NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        Object body = message.body();
        if (body instanceof NettyCustomizableResponseTypeHandlerInvoker) {
            if (!isHttp2 && !message.getHeaders().contains("Connection")) {
                if (!decodeError && (httpStatus.getCode() < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    message.getHeaders().set((CharSequence)"Connection", (CharSequence)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    message.getHeaders().set((CharSequence)"Connection", (CharSequence)HttpHeaderValues.CLOSE);
                }
            }
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)body;
            message.body(null);
            handler.invoke(request, message, context);
        } else {
            final io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
            HttpHeaders nettyHeaders = nettyResponse.headers();
            if (!isHttp2 && !nettyHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
                boolean expectKeepAlive;
                boolean bl = expectKeepAlive = nettyResponse.protocolVersion().isKeepAliveDefault() || request.getHeaders().isKeepAlive();
                if (!decodeError && (expectKeepAlive || httpStatus.getCode() < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            }
            if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)request;
            if (isHttp2) {
                this.addHttp2StreamHeader(request, nettyResponse);
            }
            io.netty.handler.codec.http.HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
            final GenericFutureListener requestCompletor = future -> {
                try {
                    Throwable throwable;
                    if (!future.isSuccess() && !((throwable = future.cause()) instanceof ClosedChannelException)) {
                        Http2Exception.StreamException se;
                        if (throwable instanceof Http2Exception.StreamException && (se = (Http2Exception.StreamException)throwable).error() == Http2Error.STREAM_CLOSED) {
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error writing final response: " + throwable.getMessage(), throwable);
                        }
                    }
                }
                finally {
                    this.cleanupRequest(context, nettyHttpRequest);
                    context.read();
                }
            };
            if (nativeRequest instanceof StreamedHttpRequest && !((StreamedHttpRequest)nativeRequest).isConsumed()) {
                StreamedHttpRequest streamedHttpRequest = (StreamedHttpRequest)nativeRequest;
                streamedHttpRequest.subscribe((Subscriber)new Subscriber<HttpContent>(){
                    private Subscription streamSub;

                    public void onSubscribe(Subscription s) {
                        this.streamSub = s;
                        s.request(1L);
                    }

                    public void onNext(HttpContent httpContent) {
                        httpContent.release();
                        this.streamSub.request(1L);
                    }

                    public void onError(Throwable t) {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
                    }

                    public void onComplete() {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
                    }
                });
            } else {
                this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
            }
        }
    }

    private void syncWriteAndFlushNettyResponse(ChannelHandlerContext context, HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse, GenericFutureListener<Future<? super Void>> requestCompletor) {
        context.writeAndFlush((Object)nettyResponse).addListener(requestCompletor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", new Object[]{nettyResponse.status().code(), request.getMethodName(), request.getUri()});
        }
    }

    private void addHttp2StreamHeader(HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse) {
        String streamId = (String)request.getHeaders().get((CharSequence)AbstractNettyHttpRequest.STREAM_ID);
        if (streamId != null) {
            nettyResponse.headers().set((CharSequence)AbstractNettyHttpRequest.STREAM_ID, (Object)streamId);
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            return ((NettyHttpResponseBuilder)message).toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private MutableHttpResponse<?> toMutableResponse(HttpResponse<?> message) {
        if (message instanceof MutableHttpResponse) {
            return (MutableHttpResponse)message;
        }
        return this.createNettyResponse(message);
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        HttpStatus httpStatus = message.status();
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)nettyHeaders).set(arg_0, arg_1));
        return new NettyMutableHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)httpStatus.getCode(), (String)httpStatus.getReason()), body instanceof ByteBuf ? body : null, ConversionService.SHARED);
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        try {
            ByteBuf byteBuf = this.encodeBodyAsByteBuf(bodyType, body, codec, context, request);
            this.setResponseBody(response, byteBuf);
            return response;
        }
        catch (LinkageError e) {
            throw new InternalServerException("Fatal error encoding bytebuf: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setResponseBody(MutableHttpResponse<?> response, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        MutableHttpHeaders headers = response.getHeaders();
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(len));
        this.setBodyContent(response, byteBuf);
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse<?> response, Object bodyContent) {
        MutableHttpResponse res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(@Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            byteBuf = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo((OutputStream)outputStream, request.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            ByteBuffer wrapped = bodyType != null && bodyType.isInstance(body) ? codec.encode(bodyType, body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc())) : codec.encode(body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc()));
            byteBuf = ((ByteBuf)wrapped.asNativeBuffer()).retain();
            if (wrapped instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                ((io.micronaut.core.io.buffer.ReferenceCounted)wrapped).release();
            }
        }
        return byteBuf;
    }

    private boolean isIgnorable(Throwable cause) {
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        void invoke(HttpRequest<?> request, MutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

