/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLogFormatParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpAccessLogHandler
extends ChannelDuplexHandler {
    public static final String HTTP_ACCESS_LOGGER = "HTTP_ACCESS_LOGGER";
    private static final AttributeKey<AccessLogHolder> ACCESS_LOGGER = AttributeKey.valueOf((String)"ACCESS_LOGGER");
    private static final String H2_PROTOCOL_NAME = "HTTP/2.0";
    private final Logger logger;
    private final AccessLogFormatParser accessLogFormatParser;
    private final Predicate<String> uriInclusion;

    public HttpAccessLogHandler(String loggerName, String spec) {
        this(loggerName == null || loggerName.isEmpty() ? null : LoggerFactory.getLogger((String)loggerName), spec, null);
    }

    public HttpAccessLogHandler(String loggerName, String spec, Predicate<String> uriInclusion) {
        this(loggerName == null || loggerName.isEmpty() ? null : LoggerFactory.getLogger((String)loggerName), spec, uriInclusion);
    }

    public HttpAccessLogHandler(Logger logger, String spec) {
        this(logger, spec, null);
    }

    public HttpAccessLogHandler(Logger logger, String spec, Predicate<String> uriInclusion) {
        this.logger = logger == null ? LoggerFactory.getLogger((String)HTTP_ACCESS_LOGGER) : logger;
        this.accessLogFormatParser = new AccessLogFormatParser(spec);
        this.uriInclusion = uriInclusion;
    }

    private SocketChannel findSocketChannel(Channel channel) {
        if (channel instanceof SocketChannel) {
            return (SocketChannel)channel;
        }
        Channel parent = channel.parent();
        if (parent == null) {
            throw new IllegalArgumentException("No socket channel available");
        }
        return this.findSocketChannel(parent);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception {
        if (this.logger.isInfoEnabled() && msg instanceof HttpRequest) {
            SocketChannel channel = this.findSocketChannel(ctx.channel());
            HttpRequest request = (HttpRequest)msg;
            AccessLogHolder accessLogHolder = this.getAccessLogHolder(ctx, true);
            assert (accessLogHolder != null);
            if (this.uriInclusion == null || this.uriInclusion.test(request.uri())) {
                HttpHeaders headers = request.headers();
                String protocol = headers.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()) || headers.contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text()) ? H2_PROTOCOL_NAME : request.protocolVersion().text();
                accessLogHolder.createLogForRequest().onRequestHeaders(channel, request.method().name(), request.headers(), request.uri(), protocol);
            } else {
                accessLogHolder.excludeRequest();
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.processWriteEvent(ctx, msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void log(ChannelHandlerContext ctx, Object msg, ChannelPromise promise, AccessLog accessLog) {
        ctx.write(msg, promise.unvoid()).addListener(future -> {
            if (future.isSuccess()) {
                accessLog.log(this.logger);
            }
        });
    }

    private void processWriteEvent(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        AccessLogHolder accessLogHolder = this.getAccessLogHolder(ctx, false);
        if (accessLogHolder != null) {
            boolean isContinueResponse = msg instanceof HttpResponse && ((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE);
            AccessLog accessLogger = accessLogHolder.getLogForResponse(msg instanceof LastHttpContent && !isContinueResponse);
            if (accessLogger != null && !isContinueResponse) {
                if (msg instanceof HttpResponse) {
                    accessLogger.onResponseHeaders(ctx, ((HttpResponse)msg).headers(), ((HttpResponse)msg).status().codeAsText().toString());
                }
                if (msg instanceof LastHttpContent) {
                    accessLogger.onLastResponseWrite(((LastHttpContent)msg).content().readableBytes());
                    this.log(ctx, msg, promise, accessLogger);
                    return;
                }
                if (msg instanceof ByteBufHolder) {
                    accessLogger.onResponseWrite(((ByteBufHolder)msg).content().readableBytes());
                } else if (msg instanceof ByteBuf) {
                    accessLogger.onResponseWrite(((ByteBuf)msg).readableBytes());
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    @Nullable
    private AccessLogHolder getAccessLogHolder(ChannelHandlerContext ctx, boolean createIfMissing) {
        Attribute attr = ctx.channel().attr(ACCESS_LOGGER);
        AccessLogHolder holder = (AccessLogHolder)attr.get();
        if (holder == null) {
            if (!createIfMissing) {
                return null;
            }
            holder = new AccessLogHolder();
            attr.set((Object)holder);
        }
        return holder;
    }

    private final class AccessLogHolder {
        private final Queue<AccessLog> liveLogs = new LinkedList<AccessLog>();
        private AccessLog logForReuse;

        private AccessLogHolder() {
        }

        AccessLog createLogForRequest() {
            AccessLog log = this.logForReuse;
            this.logForReuse = null;
            if (log != null) {
                log.reset();
            } else {
                log = HttpAccessLogHandler.this.accessLogFormatParser.newAccessLogger();
            }
            this.liveLogs.add(log);
            return log;
        }

        void excludeRequest() {
            this.liveLogs.add(null);
        }

        @Nullable
        AccessLog getLogForResponse(boolean finishResponse) {
            if (finishResponse) {
                AccessLog accessLog;
                this.logForReuse = accessLog = this.liveLogs.poll();
                return accessLog;
            }
            return this.liveLogs.peek();
        }
    }
}

