/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import jakarta.inject.Singleton;

@Requires(classes={WebSocketBeanRegistry.class})
@Singleton
@Internal
public final class WebSocketUpgradeHandlerFactory {
    private final ConversionService conversionService;
    private final NettyHttpServerConfiguration serverConfiguration;

    public WebSocketUpgradeHandlerFactory(ConversionService conversionService, NettyHttpServerConfiguration serverConfiguration) {
        this.conversionService = conversionService;
        this.serverConfiguration = serverConfiguration;
    }

    public NettyServerWebSocketUpgradeHandler create(NettyEmbeddedServer embeddedServer, NettyEmbeddedServices nettyEmbeddedServices) {
        return new NettyServerWebSocketUpgradeHandler(nettyEmbeddedServices, embeddedServer, this.conversionService, this.serverConfiguration);
    }
}

