/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyBodyAnnotationBinder;
import io.micronaut.http.server.netty.binders.NettyPublisherBodyBinder;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
final class NettyCompletableFutureBodyBinder
implements NonBlockingBodyArgumentBinder<CompletableFuture<?>> {
    private static final Argument<CompletableFuture<?>> TYPE = Argument.of(CompletableFuture.class);
    private final NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder;

    NettyCompletableFutureBodyBinder(NettyBodyAnnotationBinder<Object> nettyBodyAnnotationBinder) {
        this.nettyBodyAnnotationBinder = nettyBodyAnnotationBinder;
    }

    @NonNull
    public List<Class<?>> superTypes() {
        return Arrays.asList(CompletionStage.class, Future.class);
    }

    public Argument<CompletableFuture<?>> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<CompletableFuture<?>> bind(ArgumentConversionContext<CompletableFuture<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            ImmediateByteBody immediate;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody rootBody = nhr.byteBody();
            if (rootBody instanceof ImmediateByteBody && (immediate = (ImmediateByteBody)rootBody).empty()) {
                return ArgumentBinder.BindingResult.empty();
            }
            Optional firstTypeParameter = context.getFirstTypeVariable();
            Argument targetType = firstTypeParameter.orElse(Argument.OBJECT_ARGUMENT);
            CompletableFuture future = rootBody.buffer(nhr.getChannelHandlerContext().alloc()).map(bytes -> {
                Optional<Object> value;
                try {
                    value = this.nettyBodyAnnotationBinder.transform(nhr, (ArgumentConversionContext<Object>)context.with(targetType), (ImmediateByteBody)bytes);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return value.orElseThrow(() -> NettyPublisherBodyBinder.extractError(null, context));
            }).toCompletableFuture();
            return () -> Optional.of(future);
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

