/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class Compressor {
    private final HttpCompressionStrategy strategy;
    private final BrotliOptions brotliOptions;
    private final GzipOptions gzipOptions;
    private final DeflateOptions deflateOptions;
    private final ZstdOptions zstdOptions;
    private final SnappyOptions snappyOptions;

    Compressor(HttpCompressionStrategy strategy) {
        this.strategy = strategy;
        this.brotliOptions = Brotli.isAvailable() ? StandardCompressionOptions.brotli() : null;
        GzipOptions stdGzip = StandardCompressionOptions.gzip();
        this.gzipOptions = StandardCompressionOptions.gzip((int)strategy.getCompressionLevel(), (int)stdGzip.windowBits(), (int)stdGzip.memLevel());
        DeflateOptions stdDeflate = StandardCompressionOptions.deflate();
        this.deflateOptions = StandardCompressionOptions.deflate((int)strategy.getCompressionLevel(), (int)stdDeflate.windowBits(), (int)stdDeflate.memLevel());
        this.zstdOptions = Zstd.isAvailable() ? StandardCompressionOptions.zstd() : null;
        this.snappyOptions = StandardCompressionOptions.snappy();
    }

    @Nullable
    ChannelHandler prepare(HttpRequest request, HttpResponse response) {
        FullHttpResponse fhr;
        int code = response.status().code();
        if (code < 200 || code == 204 || code == 304 || request.method().equals((Object)HttpMethod.HEAD) || request.method().equals((Object)HttpMethod.CONNECT) && code == 200 || response.protocolVersion() == HttpVersion.HTTP_1_0) {
            return null;
        }
        if (response instanceof FullHttpResponse && !(fhr = (FullHttpResponse)response).content().isReadable()) {
            return null;
        }
        if (!this.strategy.shouldCompress(response)) {
            return null;
        }
        if (response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
            return null;
        }
        ArrayList<String> acceptEncoding = new ArrayList<String>();
        for (String s : request.headers().getAll((CharSequence)HttpHeaderNames.ACCEPT_ENCODING)) {
            acceptEncoding.addAll(Arrays.asList(s.split(",")));
        }
        Algorithm encoding = this.determineEncoding(acceptEncoding);
        if (encoding == null) {
            return null;
        }
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)encoding.contentEncoding);
        return switch (encoding) {
            default -> throw new IncompatibleClassChangeError();
            case Algorithm.BR -> this.makeBrotliEncoder();
            case Algorithm.ZSTD -> new ZstdEncoder(this.zstdOptions.compressionLevel(), this.zstdOptions.blockSize(), this.zstdOptions.maxEncodeSize());
            case Algorithm.SNAPPY -> new SnappyFrameEncoder();
            case Algorithm.GZIP -> ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP, (int)this.gzipOptions.compressionLevel(), (int)this.gzipOptions.windowBits(), (int)this.gzipOptions.memLevel());
            case Algorithm.DEFLATE -> ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.ZLIB, (int)this.deflateOptions.compressionLevel(), (int)this.deflateOptions.windowBits(), (int)this.deflateOptions.memLevel());
        };
    }

    private BrotliEncoder makeBrotliEncoder() {
        return new BrotliEncoder(this.brotliOptions.parameters());
    }

    private Algorithm determineEncoding(List<String> acceptEncoding) {
        float starQ = -1.0f;
        float brQ = -1.0f;
        float zstdQ = -1.0f;
        float snappyQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : acceptEncoding) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.parseFloat(encoding.substring(equalsPos + 1));
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.contains("*")) {
                starQ = q;
                continue;
            }
            if (encoding.contains("br") && q > brQ) {
                brQ = q;
                continue;
            }
            if (encoding.contains("zstd") && q > zstdQ) {
                zstdQ = q;
                continue;
            }
            if (encoding.contains("snappy") && q > snappyQ) {
                snappyQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (brQ > 0.0f || zstdQ > 0.0f || snappyQ > 0.0f || gzipQ > 0.0f || deflateQ > 0.0f) {
            if (brQ != -1.0f && brQ >= zstdQ && this.brotliOptions != null) {
                return Algorithm.BR;
            }
            if (zstdQ != -1.0f && zstdQ >= snappyQ && this.zstdOptions != null) {
                return Algorithm.ZSTD;
            }
            if (snappyQ != -1.0f && snappyQ >= gzipQ && this.snappyOptions != null) {
                return Algorithm.SNAPPY;
            }
            if (gzipQ != -1.0f && gzipQ >= deflateQ && this.gzipOptions != null) {
                return Algorithm.GZIP;
            }
            if (deflateQ != -1.0f && this.deflateOptions != null) {
                return Algorithm.DEFLATE;
            }
        }
        if (starQ > 0.0f) {
            if (brQ == -1.0f && this.brotliOptions != null) {
                return Algorithm.BR;
            }
            if (zstdQ == -1.0f && this.zstdOptions != null) {
                return Algorithm.ZSTD;
            }
            if (snappyQ == -1.0f && this.snappyOptions != null) {
                return Algorithm.SNAPPY;
            }
            if (gzipQ == -1.0f && this.gzipOptions != null) {
                return Algorithm.GZIP;
            }
            if (deflateQ == -1.0f && this.deflateOptions != null) {
                return Algorithm.DEFLATE;
            }
        }
        return null;
    }

    private static enum Algorithm {
        BR((CharSequence)HttpHeaderValues.BR),
        ZSTD((CharSequence)HttpHeaderValues.ZSTD),
        SNAPPY((CharSequence)HttpHeaderValues.SNAPPY),
        GZIP((CharSequence)HttpHeaderValues.GZIP),
        DEFLATE((CharSequence)HttpHeaderValues.DEFLATE);

        final CharSequence contentEncoding;

        private Algorithm(CharSequence contentEncoding) {
            this.contentEncoding = contentEncoding;
        }
    }
}

