/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Set;

abstract class AbstractHttpMessageLogElement
implements LogElement {
    private static final Set<Character> CHARACTERS_TO_ESCAPE = Set.of(Character.valueOf('\b'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\\'), Character.valueOf('\"'));
    protected Set<LogElement.Event> events;

    AbstractHttpMessageLogElement() {
    }

    protected abstract String value(HttpHeaders var1);

    private static String wrapValue(String value) {
        if (value == null || "-".equals(value) || value.isEmpty()) {
            return "-";
        }
        StringBuilder buffer = new StringBuilder(value.length() + 2);
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (CHARACTERS_TO_ESCAPE.contains(Character.valueOf(currentChar))) {
                buffer.append('\\');
                switch (currentChar) {
                    case '\b': {
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('n');
                        break;
                    }
                    case '\r': {
                        buffer.append('r');
                        break;
                    }
                    case '\t': {
                        buffer.append('t');
                        break;
                    }
                    default: {
                        buffer.append(currentChar);
                        break;
                    }
                }
                continue;
            }
            buffer.append(currentChar);
        }
        return buffer.toString();
    }

    @Override
    public Set<LogElement.Event> events() {
        return this.events;
    }

    @Override
    public String onRequestHeaders(SocketChannel channel, String method, HttpHeaders headers, String uri, String protocol) {
        if (this.events.contains((Object)LogElement.Event.ON_REQUEST_HEADERS)) {
            return AbstractHttpMessageLogElement.wrapValue(this.value(headers));
        }
        return "-";
    }

    @Override
    public String onResponseHeaders(ChannelHandlerContext ctx, HttpHeaders headers, String status) {
        if (this.events.contains((Object)LogElement.Event.ON_RESPONSE_HEADERS)) {
            return AbstractHttpMessageLogElement.wrapValue(this.value(headers));
        }
        return "-";
    }

    @Override
    public LogElement copy() {
        return this;
    }
}

