/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLogFormatParser;
import io.netty.handler.codec.http2.Http2Connection;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class Http2AccessLogManager {
    final Http2Connection connection;
    final Http2Connection.PropertyKey accessLogKey;
    final AccessLogFormatParser formatParser;
    final Logger logger;
    final Predicate<String> uriInclusion;
    AccessLog logForReuse;

    public Http2AccessLogManager(Factory factory, Http2Connection connection) {
        this.connection = connection;
        this.accessLogKey = connection.newKey();
        this.formatParser = new AccessLogFormatParser(factory.spec);
        this.logger = factory.logger == null ? LoggerFactory.getLogger((String)"HTTP_ACCESS_LOGGER") : factory.logger;
        this.uriInclusion = factory.uriInclusion;
    }

    public record Factory(Logger logger, String spec, Predicate<String> uriInclusion) {
    }
}

