/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public final class CorsAssertion {
    private final String vary;
    private final String accessControlAllowCredentials;
    private final String origin;
    private final List<HttpMethod> allowMethods;
    private final String maxAge;

    private CorsAssertion(String vary, String accessControlAllowCredentials, String origin, List<HttpMethod> allowMethods, String maxAge) {
        this.vary = vary;
        this.accessControlAllowCredentials = accessControlAllowCredentials;
        this.origin = origin;
        this.allowMethods = allowMethods;
        this.maxAge = maxAge;
    }

    public void validate(HttpResponse<?> response) {
        if (StringUtils.isNotEmpty((CharSequence)this.vary)) {
            Assertions.assertEquals((Object)this.vary, (Object)response.getHeaders().get((CharSequence)"Vary"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.accessControlAllowCredentials)) {
            Assertions.assertEquals((Object)this.accessControlAllowCredentials, (Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Credentials"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.origin)) {
            Assertions.assertEquals((Object)this.origin, (Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Origin"));
        }
        if (CollectionUtils.isNotEmpty(this.allowMethods)) {
            Assertions.assertEquals((Object)this.allowMethods.stream().map(Enum::toString).collect(Collectors.joining(",")), (Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Methods"));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.maxAge)) {
            Assertions.assertEquals((Object)this.maxAge, (Object)response.getHeaders().get((CharSequence)"Access-Control-Max-Age"));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String vary;
        private String accessControlAllowCredentials;
        private String origin;
        private List<HttpMethod> allowMethods;
        private String maxAge;

        public Builder vary(String varyValue) {
            this.vary = varyValue;
            return this;
        }

        public Builder allowCredentials(String accessControlAllowCredentials) {
            this.accessControlAllowCredentials = accessControlAllowCredentials;
            return this;
        }

        public Builder allowCredentials() {
            return this.allowCredentials("true");
        }

        public Builder allowCredentials(boolean allowCredentials) {
            return allowCredentials ? this.allowCredentials("true") : this.allowCredentials("");
        }

        public Builder allowOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder allowMethods(HttpMethod method) {
            if (this.allowMethods == null) {
                this.allowMethods = new ArrayList<HttpMethod>();
            }
            this.allowMethods.add(method);
            return this;
        }

        public Builder maxAge(String maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CorsAssertion build() {
            return new CorsAssertion(this.vary, this.accessControlAllowCredentials, this.origin, this.allowMethods, this.maxAge);
        }
    }
}

