/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.tck.CorsAssertion;
import org.junit.jupiter.api.Assertions;

public final class CorsUtils {
    private CorsUtils() {
    }

    public static void assertCorsHeadersNotPresent(HttpResponse<?> response) {
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Vary"));
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Credentials"));
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Max-Age"));
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Origin"));
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Methods"));
        Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
    }

    public static void assertCorsHeaders(HttpResponse<?> response, String origin, HttpMethod method) {
        CorsAssertion.builder().vary("Origin").allowCredentials().allowOrigin(origin).allowMethods(method).maxAge("1800").build().validate(response);
    }

    public static void assertCorsHeaders(HttpResponse<?> response, String origin, HttpMethod method, boolean allowCredentials) {
        CorsAssertion.builder().vary("Origin").allowCredentials(allowCredentials).allowOrigin(origin).allowMethods(method).maxAge("1800").build().validate(response);
    }

    public static void assertCorsHeaders(HttpResponse<?> response, String origin, HttpMethod method, String maxAge) {
        CorsAssertion.builder().vary("Origin").allowCredentials().allowOrigin(origin).allowMethods(method).maxAge(maxAge).build().validate(response);
    }
}

