/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import io.micronaut.http.uri.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.junit.jupiter.api.Test;

public class ParameterTest {
    public static final String SPEC_NAME = "ParameterTest";

    @Test
    void testGetAllMethod() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((URI)UriBuilder.of((CharSequence)"/parameters-test").path("all").queryParam("test", new Object[]{"one", "two", "three+four"}).build()), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).body("[\"one\",\"two\",\"three+four\"]").build()));
    }

    @Controller(value="/parameters-test")
    @Requires(property="spec.name", value="ParameterTest")
    static class BodyController {
        BodyController() {
        }

        @Get(uri="/all")
        List<String> all(HttpRequest request) {
            return request.getParameters().getAll((CharSequence)"test");
        }
    }
}

