/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.constraintshandler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ControllerConstraintHandlerTest {
    public static final String SPEC_NAME = "ControllerConstraintHandlerTest";
    private static final HttpResponseAssertion TEAPOT_ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).assertResponse(response -> {
        Optional json = response.getBody(Argument.of(String.class));
        Assertions.assertTrue((boolean)json.isPresent());
        Assertions.assertTrue((boolean)((String)json.get()).contains("secret"));
        Assertions.assertTrue((boolean)((String)json.get()).contains("password"));
    }).build();

    @Test
    void testPojoConstraintViolationExceptionIsHandledViaHandler() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler", (Object)"{\"username\":\"tim@micronaut.example\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).build()));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler", (Object)"{\"username\":\"invalidemail\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must be a well-formed email address")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must not be blank\"")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler/with-at-nullable", (Object)"{\"username\":\"invalidemail\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must be a well-formed email address")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler/with-at-nullable", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must not be blank\"")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method", (Object)"{\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method/with-at-nullable", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method/with-at-nullable", (Object)"{\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
    }

    @Disabled(value="currently not supported")
    @Test
    void testPojoCanHaveNullabilityAnnotationsMatchingConstraints() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler/with-non-null", (Object)"{\"username\":\"invalidemail\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must be a well-formed email address")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-handler/with-non-null", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, ControllerConstraintHandlerTest.constraintAssertion("must not be blank\"")));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method/with-non-null", (Object)"{\"username\":\"\",\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/constraints-via-on-error-method/with-non-null", (Object)"{\"password\":\"secret\"}"), (server, request) -> AssertionUtils.assertThrows(server, request, TEAPOT_ASSERTION));
    }

    private static HttpResponseAssertion constraintAssertion(String expectedMessage) {
        return HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).assertResponse(response -> {
            Optional json = response.getBody(Argument.of(String.class));
            Assertions.assertTrue((boolean)json.isPresent());
            Assertions.assertTrue((boolean)((String)json.get()).contains(expectedMessage));
        }).build();
    }

    @Introspected
    static class CredentialsWithNonNull {
        @NotBlank
        @Email
        @NonNull
        private final String username;
        @NotBlank
        @NonNull
        private final String password;

        CredentialsWithNonNull(@NonNull String username, @NonNull String password) {
            this.username = username;
            this.password = password;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public String getPassword() {
            return this.password;
        }
    }

    @Introspected
    static class CredentialsWithNullable {
        @NotBlank
        @Email
        @Nullable
        private final String username;
        @NotBlank
        @Nullable
        private final String password;

        CredentialsWithNullable(@Nullable String username, @Nullable String password) {
            this.username = username;
            this.password = password;
        }

        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }
    }

    @Introspected
    static class CredentialsWithoutNullabilityAnnotation {
        @NotBlank
        @Email
        private final String username;
        @NotBlank
        private final String password;

        CredentialsWithoutNullabilityAnnotation(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    @Controller(value="/constraints-via-on-error-method")
    @Requires(property="spec.name", value="ControllerConstraintHandlerTest")
    static class OnErrorMethodController {
        OnErrorMethodController() {
        }

        @Post
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void login(@Body @NotNull @Valid CredentialsWithoutNullabilityAnnotation credentials) {
        }

        @Post(value="/with-at-nullable")
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void loginWithNullable(@Body @NotNull @Valid CredentialsWithNullable credentials) {
        }

        @Post(value="/with-non-null")
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void loginWithNullable(@Body @NotNull @Valid CredentialsWithNonNull credentials) {
        }

        @Error(exception=ConstraintViolationException.class)
        @Status(value=HttpStatus.I_AM_A_TEAPOT)
        Optional<Map> constraintsEx(ConstraintViolationException e, HttpRequest<?> request) {
            return request.getBody(Map.class);
        }
    }

    @Controller(value="/constraints-via-handler")
    @Requires(property="spec.name", value="ControllerConstraintHandlerTest")
    static class BodyController {
        BodyController() {
        }

        @Post
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void login(@Body @NotNull @Valid CredentialsWithoutNullabilityAnnotation credentials) {
        }

        @Post(value="/with-at-nullable")
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void login(@Body @NotNull @Valid CredentialsWithNullable credentials) {
        }

        @Post(value="/with-non-null")
        @Produces(value={"text/plain"})
        @Status(value=HttpStatus.OK)
        void login(@Body @NotNull @Valid CredentialsWithNonNull credentials) {
        }
    }
}

