/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.server.tck.ServerUnderTest;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class EmbeddedServerUnderTest
implements ServerUnderTest {
    private EmbeddedServer embeddedServer;
    private HttpClient httpClient;
    private BlockingHttpClient client;

    public EmbeddedServerUnderTest(@NonNull Map<String, Object> properties) {
        this.embeddedServer = (EmbeddedServer)ApplicationContext.run(EmbeddedServer.class, properties, (String[])new String[0]);
    }

    @Override
    public <I, O> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType) {
        return this.getBlockingHttpClient().exchange(request, bodyType);
    }

    public ApplicationContext getApplicationContext() {
        return this.embeddedServer.getApplicationContext();
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.embeddedServer != null) {
            this.embeddedServer.close();
        }
    }

    @Override
    @NonNull
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.embeddedServer).map(EmbeddedServer::getPort);
    }

    @NonNull
    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = (HttpClient)this.getApplicationContext().createBean(HttpClient.class, new Object[]{this.embeddedServer.getURL()});
        }
        return this.httpClient;
    }

    @NonNull
    private BlockingHttpClient getBlockingHttpClient() {
        if (this.client == null) {
            this.client = this.getHttpClient().toBlocking();
        }
        return this.client;
    }
}

