/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Test;

public class HeadersTest {
    public static final String SPEC_NAME = "HeadersTest";

    @Test
    void headersAreCaseInsensitiveAsPerMessageHeadersSpecification() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((String)"/foo/ok").header((CharSequence)"aCcEpT", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"status\":\"ok\"}").build()));
        TestScenario.asserts(SPEC_NAME, HttpRequest.GET((String)"/foo/bar").header((CharSequence)"fOO", (CharSequence)"ok"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"status\":\"ok\"}").build()));
    }

    @Controller(value="/foo")
    @Requires(property="spec.name", value="HeadersTest")
    static class ProduceController {
        ProduceController() {
        }

        @Get(value="/ok", produces={"application/json"})
        String getOkAsJson() {
            return "{\"status\":\"ok\"}";
        }

        @Get(value="/bar", produces={"application/json"})
        String getFooAsJson(@Header(value="Foo") String foo) {
            return "{\"status\":\"" + foo + "\"}";
        }
    }
}

