/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.tck.AssertionUtils;
import io.micronaut.http.server.tck.BodyAssertion;
import io.micronaut.http.server.tck.HttpResponseAssertion;
import io.micronaut.http.server.tck.TestScenario;
import java.io.IOException;
import java.util.Objects;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;

public class BodyTest {
    public static final String SPEC_NAME = "BodyTest";

    @Test
    void testCustomBodyPOJO() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/response-body/pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomBodyPOJODefaultToJSON() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/response-body/pojo", (Object)"{\"x\":10,\"y\":20}"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomBodyPOJOWithWholeRequest() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/response-body/pojo-and-request", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build());
    }

    @Test
    void testCustomBodyPOJOReactiveTypes() throws IOException {
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/response-body/pojo-reactive", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomListBodyPOJOReactiveTypes() throws IOException {
        String body = "[{\"x\":10,\"y\":20},{\"x\":30,\"y\":40}]";
        TestScenario.asserts(SPEC_NAME, HttpRequest.POST((String)"/response-body/pojo-flux", (Object)body).header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow(server, request, HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.builder().body(body).equals()).build()));
    }

    static class Point {
        private Integer x;
        private Integer y;

        Point() {
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (!Objects.equals(this.x, point.x)) {
                return false;
            }
            return Objects.equals(this.y, point.y);
        }

        public int hashCode() {
            int result = this.x != null ? this.x.hashCode() : 0;
            result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
            return result;
        }
    }

    @Controller(value="/response-body")
    @Requires(property="spec.name", value="BodyTest")
    static class BodyController {
        BodyController() {
        }

        @Post(uri="/pojo")
        @Status(value=HttpStatus.CREATED)
        Point post(@Body Point data) {
            return data;
        }

        @Post(uri="/pojo-and-request")
        @Status(value=HttpStatus.CREATED)
        Point postRequest(HttpRequest<Point> request) {
            return request.getBody().orElse(null);
        }

        @Post(uri="/pojo-reactive")
        @Status(value=HttpStatus.CREATED)
        @SingleResult
        Publisher<Point> post(@Body Publisher<Point> data) {
            return data;
        }

        @Post(uri="/pojo-flux")
        @Status(value=HttpStatus.CREATED)
        Publisher<Point> postMany(@Body Publisher<Point> data) {
            return data;
        }

        @Post(uri="/bytes", consumes={"text/plain"})
        @Status(value=HttpStatus.CREATED)
        String postBytes(@Body byte[] bytes) {
            return new String(bytes);
        }
    }
}

