/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.cors;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.cors.CrossOrigin;
import io.micronaut.http.server.tck.CorsUtils;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.http.uri.UriBuilder;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CrossOriginTest {
    private static final String SPECNAME = "CrossOriginTest";

    @Test
    void crossOriginAnnotationWithMatchingOrigin() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/foo").path("bar"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build()));
    }

    @Test
    void crossOriginAnnotationWithNoMatchingOrigin() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/foo").path("bar"), "https://bar.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.METHOD_NOT_ALLOWED).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()));
    }

    @Test
    void crossOriginAnnotationWithAnyOriginAnyHeaderAllowedByDefault() throws IOException {
        TestScenario.asserts((String)SPECNAME, (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/foo").path("all"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Request-Headers", (CharSequence)"foo"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build()));
    }

    @Test
    void verifyHttpMethodIsValidatedInACorsRequest() {
        Assertions.assertAll((Executable[])new Executable[]{() -> TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/methods").path("getit"), "https://www.google.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://www.google.com", HttpMethod.GET);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build())), () -> TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/methods").path("postit").path("id"), "https://www.google.com", HttpMethod.POST), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://www.google.com", HttpMethod.POST);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build())), () -> TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/methods").path("deleteit").path("id"), "https://www.google.com", HttpMethod.DELETE), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.FORBIDDEN).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()))});
    }

    @Test
    void allowedOriginsRegexHappyPath() throws IOException {
        URI uri = UriBuilder.of((CharSequence)"/allowedoriginsregex").path("foo").build();
        String origin = "https://foo.com";
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(uri, origin, HttpMethod.GET), CrossOriginTest.happyPathAssertion(origin));
        origin = "http://foo.com";
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(uri, origin, HttpMethod.GET), CrossOriginTest.happyPathAssertion(origin));
    }

    @Test
    void allowedOriginsAndAllowedOriginsRegexHappyPath() throws IOException {
        URI uri = UriBuilder.of((CharSequence)"/allowedoriginsregex").path("bar").build();
        String origin = "https://foo.com";
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(uri, origin, HttpMethod.GET), CrossOriginTest.happyPathAssertion(origin));
        origin = "https://bar.com";
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(uri, origin, HttpMethod.GET), CrossOriginTest.happyPathAssertion(origin));
        origin = "http://bar.com";
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(uri, origin, HttpMethod.GET), CrossOriginTest.happyPathAssertion(origin));
    }

    private static BiConsumer<ServerUnderTest, HttpRequest<?>> happyPathAssertion(String origin) {
        return (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, origin, HttpMethod.GET);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build());
    }

    @Test
    void allowedOriginsRegexFailure() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/allowedoriginsregex").path("foobar"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.METHOD_NOT_ALLOWED).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()));
    }

    @Test
    void allowedHeadersHappyPath() throws IOException {
        TestScenario.asserts((String)SPECNAME, (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/allowedheaders").path("bar"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Request-Headers", (CharSequence)"Authorization,Content-Type"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Allow-Headers"));
        }).build()));
    }

    @Test
    void allowedHeadersFailure() throws IOException {
        TestScenario.asserts((String)SPECNAME, (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/allowedheaders").path("bar"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Request-Headers", (CharSequence)"foo"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.FORBIDDEN).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()));
    }

    @Test
    void defaultAccessControlExposeHeaderValueIsNotSet() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/exposedheaders").path("foo"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Expose-Headers"));
        }).build()));
    }

    @Test
    void httHeaderValueAccessControlExposeHeaderValueCanBeSetViaCrossOriginAnnotation() throws IOException {
        TestScenario.asserts((String)SPECNAME, Map.of("micronaut.server.cors.single-header", "true"), (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/exposedheaders").path("bar"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Expose-Headers", (CharSequence)"foo"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Expose-Headers"));
            Assertions.assertEquals((Object)"Content-Encoding,Kuma-Revision", (Object)response.getHeaders().get((CharSequence)"Access-Control-Expose-Headers"));
        }).build()));
    }

    @Test
    void defaultAccessControlAllowCredentialsValueIsNotSet() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/credentials").path("foo"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false);
            Assertions.assertFalse((boolean)response.getHeaders().names().contains("Access-Control-Allow-Credentials"));
        }).build()));
    }

    @Test
    void defaultAccessControlAllowCredentialsValueIsSet() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/credentials").path("bar"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Allow-Credentials"));
            Assertions.assertEquals((Object)"true", (Object)response.getHeaders().get((CharSequence)"Access-Control-Allow-Credentials"));
        }).build()));
    }

    @Test
    void defaultAccessControlMaxAgeValueIsSet() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/maxage").path("foo"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET);
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Max-Age"));
            Assertions.assertEquals((Object)"1800", (Object)response.getHeaders().get((CharSequence)"Access-Control-Max-Age"));
        }).build()));
    }

    @Test
    void accessControlMaxAgeValueIsSet() throws IOException {
        TestScenario.asserts((String)SPECNAME, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/maxage").path("bar"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> {
            CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, "1000");
            Assertions.assertTrue((boolean)response.getHeaders().names().contains("Access-Control-Max-Age"));
            Assertions.assertEquals((Object)"1000", (Object)response.getHeaders().get((CharSequence)"Access-Control-Max-Age"));
        }).build()));
    }

    @Test
    void versionedPreflightBehavesAsExpectedWithDefaultVersion() {
        Map<String, Object> config = CrossOriginTest.versionedRoutesConfig();
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            config.put("micronaut.router.versioning.default-version", 1);
            TestScenario.asserts((String)SPECNAME, (Map)config, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("common"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false)).build()));
        }, () -> {
            config.put("micronaut.router.versioning.default-version", 2);
            TestScenario.asserts((String)SPECNAME, (Map)config, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("common"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false)).build()));
        }, () -> {
            config.put("micronaut.router.versioning.default-version", 2);
            TestScenario.asserts((String)SPECNAME, (Map)config, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("new"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false)).build()));
        }});
    }

    @Test
    void versionedPreflightWithHeaderNoDefaultVersion() throws IOException {
        Map<String, Object> config = CrossOriginTest.versionedRoutesConfig();
        TestScenario.asserts((String)SPECNAME, config, (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("new"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Request-Headers", (CharSequence)"x-api-version"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false)).build()));
    }

    @Test
    void versionedPreflightWhenDefaultVersionNotMatchHasHeader() throws IOException {
        Map<String, Object> config = CrossOriginTest.versionedRoutesConfig();
        config.put("micronaut.router.versioning.default-version", 1);
        TestScenario.asserts((String)SPECNAME, config, (HttpRequest)CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("new"), "https://foo.com", HttpMethod.GET).header((CharSequence)"Access-Control-Request-Headers", (CharSequence)"x-api-version"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> CorsUtils.assertCorsHeaders(response, "https://foo.com", HttpMethod.GET, false)).build()));
    }

    @Test
    void versionedPreflightFailsWhenDefaultVersionNotMatchAndNoHeader() throws IOException {
        Map<String, Object> config = CrossOriginTest.versionedRoutesConfig();
        config.put("micronaut.router.versioning.default-version", 1);
        TestScenario.asserts((String)SPECNAME, config, CrossOriginTest.preflight(UriBuilder.of((CharSequence)"/version").path("new"), "https://foo.com", HttpMethod.GET), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).assertResponse(CorsUtils::assertCorsHeadersNotPresent).build()));
    }

    private static Map<String, Object> versionedRoutesConfig() {
        return CollectionUtils.mapOf((Object[])new Object[]{"micronaut.router.versioning.enabled", "true", "micronaut.router.versioning.header.enabled", "true", "micronaut.router.versioning.header.names", Collections.singletonList("x-api-version")});
    }

    private static MutableHttpRequest<?> preflight(UriBuilder uriBuilder, String originValue, HttpMethod method) {
        return CrossOriginTest.preflight(uriBuilder.build(), originValue, method);
    }

    private static MutableHttpRequest<?> preflight(URI uri, String originValue, HttpMethod method) {
        return HttpRequest.OPTIONS((URI)uri).header((CharSequence)"Accept", (CharSequence)"text/plain").header((CharSequence)"Origin", (CharSequence)originValue).header((CharSequence)"Access-Control-Request-Method", (CharSequence)method);
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Replaces(value=HttpHostResolver.class)
    @Singleton
    static class HttpHostResolverReplacement
    implements HttpHostResolver {
        HttpHostResolverReplacement() {
        }

        public String resolve(@Nullable HttpRequest request) {
            return "https://micronautexample.com";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @CrossOrigin(value={"https://foo.com"})
    @Controller(value="/version")
    static class ApiVersionController {
        ApiVersionController() {
        }

        @Version(value="1")
        @Produces(value={"text/plain"})
        @Get(value="common")
        public String commonV1() {
            return "This endpoint exists both in V1 and V2";
        }

        @Version(value="2")
        @Produces(value={"text/plain"})
        @Get(value="common")
        public String commonV2() {
            return "This endpoint exists both in V1 and V2";
        }

        @Version(value="2")
        @Produces(value={"text/plain"})
        @Get(value="new")
        public String newV2() {
            return "This is a new endpoint in V2 of the API";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/maxage")
    static class MaxAge {
        MaxAge() {
        }

        @CrossOrigin(value={"https://foo.com"})
        @Produces(value={"text/plain"})
        @Get(value="/foo")
        String foo() {
            return "foo";
        }

        @CrossOrigin(value={"https://foo.com"}, maxAge=1000L)
        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String bar() {
            return "bar";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/credentials")
    static class Credentials {
        Credentials() {
        }

        @CrossOrigin(value={"https://foo.com"}, allowCredentials=false)
        @Produces(value={"text/plain"})
        @Get(value="/foo")
        String foo() {
            return "foo";
        }

        @CrossOrigin(value={"https://foo.com"})
        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String bar() {
            return "bar";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/exposedheaders")
    static class ExposedHeaders {
        ExposedHeaders() {
        }

        @CrossOrigin(value={"https://foo.com"}, exposedHeaders={"Content-Encoding", "Kuma-Revision"})
        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String bar() {
            return "bar";
        }

        @CrossOrigin(value={"https://foo.com"})
        @Produces(value={"text/plain"})
        @Get(value="/foo")
        String foo() {
            return "foo";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/allowedheaders")
    @CrossOrigin(value={"https://foo.com"}, allowedHeaders={"Content-Type", "Authorization"})
    static class AllowedHeaders {
        AllowedHeaders() {
        }

        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String index() {
            return "bar";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/methods")
    @CrossOrigin(allowedOrigins={"https://www.google.com"}, allowedMethods={HttpMethod.GET, HttpMethod.POST})
    static class AllowedMethods {
        AllowedMethods() {
        }

        @Produces(value={"text/plain"})
        @Get(value="/getit")
        String canGet() {
            return "get";
        }

        @Produces(value={"text/plain"})
        @Post(value="/postit/{id}")
        String canPost(@PathVariable String id) {
            return id;
        }

        @Delete(value="/deleteit/{id}")
        String cantDelete(@PathVariable String id) {
            return id;
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/allowedoriginsregex")
    static class AllowedOriginsRegex {
        AllowedOriginsRegex() {
        }

        @CrossOrigin(allowedOriginsRegex="^http(|s):\\/\\/foo\\.com$")
        @Produces(value={"text/plain"})
        @Get(value="/foo")
        String foo() {
            return "foo";
        }

        @CrossOrigin(allowedOrigins={"https://foo.com"}, allowedOriginsRegex="^http(|s):\\/\\/bar\\.com$")
        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String bar() {
            return "bar";
        }

        @CrossOrigin(value={"^http(|s):\\/\\/foo\\.com$"})
        @Produces(value={"text/plain"})
        @Get(value="/foobar")
        String foobar() {
            return "foobar";
        }
    }

    @Requires(property="spec.name", value="CrossOriginTest")
    @Controller(value="/foo")
    static class Foo {
        Foo() {
        }

        @CrossOrigin(value={"https://foo.com"})
        @Produces(value={"text/plain"})
        @Get(value="/bar")
        String index() {
            return "bar";
        }

        @CrossOrigin
        @Produces(value={"text/plain"})
        @Get(value="/all")
        String defaults() {
            return "bar";
        }
    }
}

