/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;

public class PublisherExceptionHandlerTest {
    private static final String SPEC_NAME = "PublisherExceptionHandlerTest";

    @Test
    public void publisherError() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/publisher-error?msg=foo")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("handled: foo").build())).run();
    }

    @Test
    public void validationIsWorking() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/publisher-error?msg=")).assertion((server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.BAD_REQUEST).headers(Collections.singletonMap("Content-Type", "application/json")).build())).run();
    }

    static class MyException
    extends Exception {
        public MyException(String message) {
            super(message);
        }
    }

    @Singleton
    @Requires(property="spec.name", value="PublisherExceptionHandlerTest")
    static class MyExceptionHandler
    implements ExceptionHandler<MyException, String> {
        MyExceptionHandler() {
        }

        public String handle(HttpRequest request, MyException exception) {
            return "handled: " + exception.getMessage();
        }
    }

    @Controller(value="/publisher-error")
    @Requires(property="spec.name", value="PublisherExceptionHandlerTest")
    static class MyController {
        MyController() {
        }

        @Get
        public Publisher<String> errorPublisher(@NotBlank String msg) throws MyException {
            throw new MyException(msg);
        }
    }
}

