/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.bodywritable;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HtmlBodyWritableTest {
    public static final String SPEC_NAME = "ControllerConstraintHandlerTest";
    private static final HttpResponseAssertion ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("<!DOCTYPE html><html></html>").equals()).assertResponse(response -> {
        Assertions.assertTrue((boolean)response.getContentType().isPresent());
        Assertions.assertEquals((Object)MediaType.TEXT_HTML_TYPE, response.getContentType().get());
    }).build();

    @Test
    void htmlWritable() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/html/writable"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void htmlWritableMono() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/html/writablemono"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void htmlWritableFluxFilter() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/html/writablefluxfilter"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Requires(property="spec.name", value="ControllerConstraintHandlerTest")
    @Filter(value={"/html/writablefluxfilter"})
    static class MockFilter
    implements HttpServerFilter {
        MockFilter() {
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            return Flux.from((Publisher)chain.proceed(request)).switchMap(response -> {
                Writable writable = out -> out.write("<!DOCTYPE html><html></html>");
                response.body((Object)writable);
                response.contentType((CharSequence)"text/html");
                return Flux.just((Object)response);
            });
        }
    }

    @Controller(value="/html")
    @Requires(property="spec.name", value="ControllerConstraintHandlerTest")
    static class OnErrorMethodController {
        OnErrorMethodController() {
        }

        @Get(value="/writable")
        @Produces(value={"text/html"})
        Writable index() {
            return out -> out.write("<!DOCTYPE html><html></html>");
        }

        @Get(value="/writablemono")
        @Produces(value={"text/html"})
        Mono<Writable> indexmono() {
            Writable writable = out -> out.write("<!DOCTYPE html><html></html>");
            return Mono.just((Object)writable);
        }

        @Get(value="/writablefluxfilter")
        Map<String, Object> indexfluxfilter() {
            return Collections.emptyMap();
        }
    }
}

