/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MiscTest {
    public static final String SPEC_NAME = "MiscTest";

    @Test
    void testSelectedRouteReflectsAcceptHeader() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/bar/ok").header((CharSequence)"Accept", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"status\":\"ok\"}").build()));
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/bar/ok").header((CharSequence)"Accept", (CharSequence)"text/html"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("<div>ok</div>").build()));
    }

    @Test
    void testBehaviourOf404() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/does-not-exist").header((CharSequence)"Accept", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).build()));
    }

    @Test
    void postFormUrlEncodedBodyBindingToPojoWorks() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form", (Object)"message=World").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    @Disabled(value="not supported anymore")
    void postFormUrlEncodedBodyBindingToPojoWorksIfYouDontSpecifyBodyAnnotation() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/without-body-annotation", (Object)"message=World").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    void formUrlEncodedWithBodyAnnotationAndANestedAttribute() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/nested-attribute", (Object)"message=World").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    void applicationJsonWithBodyAnnotationAndANestedAttribute() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/json-nested-attribute", (Object)"{\"message\":\"World\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    @Disabled(value="not supported anymore")
    void applicationJsonWithoutBodyAnnotation() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/json-without-body-annotation", (Object)"{\"message\":\"World\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    void applicationJsonWithBodyAnnotationAndANestedAttributeAndMapReturnRenderedAsJSON() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/json-nested-attribute-with-map-return", (Object)"{\"message\":\"World\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"message\":\"Hello World\"}").build()));
    }

    @Test
    void applicationJsonWithBodyAnnotationAndObjectReturnRenderedAsJson() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/form/json-with-body-annotation-and-with-object-return", (Object)"{\"message\":\"World\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("{\"greeting\":\"Hello World\"}").build()));
    }

    @Controller(value="/form")
    @Requires(property="spec.name", value="MiscTest")
    static class FormController {
        FormController() {
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/without-body-annotation")
        String withoutBodyAnnotation(MessageCreate messageCreate) {
            return "{\"message\":\"Hello " + messageCreate.getMessage() + "\"}";
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post
        String save(@Body MessageCreate messageCreate) {
            return "{\"message\":\"Hello " + messageCreate.getMessage() + "\"}";
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/nested-attribute")
        String save(@Body(value="message") String value) {
            return "{\"message\":\"Hello " + value + "\"}";
        }

        @Consumes(value={"application/json"})
        @Post(value="/json-without-body-annotation")
        String jsonWithoutBody(MessageCreate messageCreate) {
            return "{\"message\":\"Hello " + messageCreate.getMessage() + "\"}";
        }

        @Consumes(value={"application/json"})
        @Post(value="/json-nested-attribute")
        String jsonNestedAttribute(@Body(value="message") String value) {
            return "{\"message\":\"Hello " + value + "\"}";
        }

        @Consumes(value={"application/json"})
        @Post(value="/json-nested-attribute-with-map-return")
        Map<String, String> jsonNestedAttributeWithMapReturn(@Body(value="message") String value) {
            return Collections.singletonMap("message", "Hello " + value);
        }

        @Consumes(value={"application/json"})
        @Post(value="/json-with-body-annotation-and-with-object-return")
        MyResponse jsonNestedAttributeWithObjectReturn(@Body MessageCreate messageCreate) {
            return new MyResponse("Hello " + messageCreate.getMessage());
        }
    }

    @Introspected
    static class MyResponse {
        @NonNull
        @NotBlank
        private final String greeting;

        public MyResponse(@NonNull String greeting) {
            this.greeting = greeting;
        }

        @NonNull
        public String getGreeting() {
            return this.greeting;
        }
    }

    @Introspected
    static class MessageCreate {
        @NonNull
        @NotBlank
        private final String message;

        MessageCreate(@NonNull String message) {
            this.message = message;
        }

        @NonNull
        String getMessage() {
            return this.message;
        }
    }

    @Controller(value="/bar")
    @Requires(property="spec.name", value="MiscTest")
    static class ProduceController {
        ProduceController() {
        }

        @Get(value="/ok", produces={"application/json"})
        String getOkAsJson() {
            return "{\"status\":\"ok\"}";
        }

        @Get(value="/ok", produces={"text/html"})
        String getOkAsHtml() {
            return "<div>ok</div>";
        }
    }

    @Controller
    @Requires(property="spec.name", value="MiscTest")
    static class SimpleController {
        SimpleController() {
        }

        @Get(uri="/foo")
        HttpResponse<String> getParamValue(HttpRequest request) {
            return HttpResponse.ok().body((Object)((String)request.getParameters().get((CharSequence)"param"))).header((CharSequence)"foo", (CharSequence)"bar");
        }
    }
}

