/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.http.uri.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestUriTest {
    public static final String SPEC_NAME = "RequestUriTest";

    @Test
    void testRequestUriContainsQueryValue() throws IOException {
        URI uri = UriBuilder.of((CharSequence)"/requesturi").queryParam("A", new Object[]{"foo"}).queryParam("B", new Object[]{"bar"}).build();
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((URI)uri), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
            Optional resultOptional = httpResponse.getBody(String.class);
            Assertions.assertTrue((boolean)resultOptional.isPresent());
            String result = (String)resultOptional.get();
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((int)1, (int)RequestUriTest.countOcurrences(result, "A=foo"));
            Assertions.assertEquals((int)1, (int)RequestUriTest.countOcurrences(result, "B=bar"));
        }).build()));
    }

    private static int countOcurrences(String str, String findStr) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = str.indexOf(findStr, lastIndex)) == -1) continue;
            ++count;
            lastIndex += findStr.length();
        }
        return count;
    }

    @Requires(property="spec.name", value="RequestUriTest")
    @Controller(value="/requesturi")
    static class TestController {
        TestController() {
        }

        @Get
        String index(HttpRequest<?> request) {
            return request.getUri().toASCIIString();
        }
    }
}

