/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.hateoas;

import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.hateoas.Resource;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.json.JsonMapper;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonErrorSerdeTest {
    private static final String JSON_ERROR = "{\"_links\":{\"self\":[{\"href\":\"/resolve\",\"templated\":false}]},\"_embedded\":{\"errors\":[{\"message\":\"Internal Server Error: Something bad happened\"}]},\"message\":\"Internal Server Error\"}";
    private static final String SPEC_NAME = "JsonErrorSerdeTest";

    @Test
    void canDeserializeAJsonErrorAsAGenericResource() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, Collections.emptyMap());){
            JsonMapper jsonMapper = (JsonMapper)server.getApplicationContext().getBean(JsonMapper.class);
            Resource resource = (Resource)jsonMapper.readValue(JSON_ERROR, Resource.class);
            this.testResource(resource);
        }
    }

    @Test
    void jsonErrorShouldBeDeserializableFromAString() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, Collections.emptyMap());){
            JsonMapper jsonMapper = (JsonMapper)server.getApplicationContext().getBean(JsonMapper.class);
            JsonError jsonError = (JsonError)jsonMapper.readValue(JSON_ERROR, JsonError.class);
            this.testResource(jsonError);
        }
    }

    private <T extends Resource> void testResource(T resource) {
        Assertions.assertNotNull(resource);
        Assertions.assertTrue((boolean)resource.getEmbedded().getFirst((CharSequence)"errors").isPresent(), (String)"errors should be present");
        Assertions.assertTrue((boolean)resource.getLinks().getFirst((CharSequence)"self").isPresent(), (String)"self link should be present");
        Assertions.assertEquals((Object)"/resolve", resource.getLinks().getFirst((CharSequence)"self").map(Link::getHref).orElse(null));
        Assertions.assertFalse((boolean)resource.getLinks().getFirst((CharSequence)"self").map(Link::isTemplated).orElse(true), (String)"self link should not be templated");
    }
}

