/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class FilterProxyTest {
    public static final String SPEC_NAME = "FilterProxyTest";
    public static final String PROP_MICRONAUT_SERVER_CORS_ENABLED = "micronaut.server.cors.enabled";

    @Test
    void testFiltersAreRunCorrectly() throws IOException {
        Map<String, String> configuration = Map.of(PROP_MICRONAUT_SERVER_CORS_ENABLED, "true");
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, configuration);){
            MutableHttpRequest request = HttpRequest.GET((String)"/filter-test/redirection");
            AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("OK").headers(Collections.singletonMap("X-Test-Filter", "true")).build());
        }
    }

    @Filter(value={"/filter-test/**"})
    @Requires(property="spec.name", value="FilterProxyTest")
    static class TestFilter
    implements HttpServerFilter {
        private final ProxyHttpClient client;
        private final EmbeddedServer embeddedServer;

        public TestFilter(ProxyHttpClient client, EmbeddedServer embeddedServer) {
            this.client = client;
            this.embeddedServer = embeddedServer;
        }

        public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
            MutableHttpRequest newRequest = request.mutate().uri(b -> b.scheme(this.embeddedServer.getScheme()).host(this.embeddedServer.getHost()).port(this.embeddedServer.getPort()).replacePath("/ok"));
            Publisher proxyRequest = this.client.proxy((HttpRequest)newRequest);
            return Flux.from((Publisher)proxyRequest).map(httpResponse -> {
                httpResponse.getHeaders().add((CharSequence)"X-Test-Filter", (CharSequence)"true");
                return httpResponse;
            });
        }
    }

    @Controller(value="/ok")
    @Requires(property="spec.name", value="FilterProxyTest")
    static class TestController {
        TestController() {
        }

        @Get
        String ok() {
            return "OK";
        }
    }
}

