/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.codec;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonCodecAdditionalTypeAutomaticTest {
    public static final String SPEC_NAME = "JsonCodecAdditionalTypeAutomaticTest";

    @Test
    void itIsPossibleToCanRegisterAdditionTypesForJsonCodec() throws IOException {
        HttpResponseAssertion assertion = HttpResponseAssertion.builder().body(BodyAssertion.builder().body("https://jsonfeed.org").contains()).status(HttpStatus.OK).assertResponse(response -> Assertions.assertTrue((boolean)response.header((CharSequence)"Content-Type").contains("application/feed+json"))).build();
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/json-additional-codec").header((CharSequence)"Accept", (CharSequence)"application/feed+json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)assertion));
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/json-additional-codec/pojo").header((CharSequence)"Accept", (CharSequence)"application/feed+json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)assertion));
    }

    @Introspected
    static class JsonFeed {
        private final String version;
        private final String title;
        @JsonProperty(value="home_page_url")
        private final String homePageUrl;
        @JsonProperty(value="feed_url")
        private final String feedUrl;

        public JsonFeed(String version, String title, String homePageUrl, String feedUrl) {
            this.version = version;
            this.title = title;
            this.homePageUrl = homePageUrl;
            this.feedUrl = feedUrl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTitle() {
            return this.title;
        }

        public String getHomePageUrl() {
            return this.homePageUrl;
        }

        public String getFeedUrl() {
            return this.feedUrl;
        }
    }

    @Requires(property="spec.name", value="JsonCodecAdditionalTypeAutomaticTest")
    @Controller
    static class JsonFeedController {
        JsonFeedController() {
        }

        @Produces(value={"application/feed+json"})
        @Get(value="/json-additional-codec")
        String index() {
            return "{\n    \"version\": \"https://jsonfeed.org/version/1\",\n    \"title\": \"My Example Feed\",\n    \"home_page_url\": \"https://example.org/\",\n    \"feed_url\": \"https://example.org/feed.json\",\n    ]\n}";
        }

        @Produces(value={"application/feed+json"})
        @Get(value="/json-additional-codec/pojo")
        JsonFeed pojo() {
            return new JsonFeed("https://jsonfeed.org/version/1", "My Example Feed", "https://example.org/", "https://example.org/feed.json");
        }
    }
}

