/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.textplain;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.math.BigDecimal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TxtPlainBigDecimalTest {
    public static final String SPEC_NAME = "TxtPlainBigDecimalTest";
    private static final HttpResponseAssertion ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("7.7").equals()).assertResponse(response -> {
        Assertions.assertTrue((boolean)response.getContentType().isPresent());
        Assertions.assertEquals((Object)MediaType.TEXT_PLAIN_TYPE, response.getContentType().get());
    }).build();

    @Test
    void txtBigDecimal() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/bigdecimal").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void txtBigDecimalMono() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/bigdecimal/mono").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void txtBigDecimalFlux() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/bigdecimal/flux").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Controller(value="/txt")
    @Requires(property="spec.name", value="TxtPlainBigDecimalTest")
    static class OnErrorMethodController {
        OnErrorMethodController() {
        }

        @Get(value="/bigdecimal")
        @Produces(value={"text/plain"})
        BigDecimal index() {
            return new BigDecimal("7.7");
        }

        @Get(value="/bigdecimal/mono")
        @Produces(value={"text/plain"})
        @SingleResult
        Publisher<BigDecimal> mono() {
            return Mono.just((Object)new BigDecimal("7.7"));
        }

        @Get(value="/bigdecimal/flux")
        @Produces(value={"text/plain"})
        @SingleResult
        Publisher<BigDecimal> flux() {
            return Flux.just((Object)new BigDecimal("7.7"));
        }
    }
}

