/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import javax.inject.Singleton;

@Singleton
@Primary
@Produces
public class ContentLengthExceededHandler
implements ExceptionHandler<ContentLengthExceededException, HttpResponse> {
    @Override
    public HttpResponse handle(HttpRequest request, ContentLengthExceededException exception) {
        JsonError error = new JsonError(exception.getMessage());
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.status((HttpStatus)HttpStatus.REQUEST_ENTITY_TOO_LARGE).body((Object)error);
    }
}

