/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.ProxyHeaderParser;
import io.micronaut.runtime.server.EmbeddedServer;
import java.net.URI;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class DefaultHttpHostResolver
implements HttpHostResolver {
    private final Provider<EmbeddedServer> embeddedServer;
    private final HttpServerConfiguration serverConfiguration;

    public DefaultHttpHostResolver(HttpServerConfiguration serverConfiguration, Provider<EmbeddedServer> embeddedServer) {
        this.serverConfiguration = serverConfiguration;
        this.embeddedServer = embeddedServer;
    }

    @Override
    @NonNull
    public String resolve(@Nullable HttpRequest request) {
        if (request != null) {
            HttpServerConfiguration.HostResolutionConfiguration configuration = this.serverConfiguration.getHostResolution();
            if (configuration != null) {
                return this.getConfiguredHost(request, configuration);
            }
            return this.getDefaultHost(request);
        }
        return this.getEmbeddedHost();
    }

    protected String getEmbeddedHost() {
        EmbeddedServer server = (EmbeddedServer)this.embeddedServer.get();
        int port = server.getPort();
        if (port > -1 && port != 80 && port != 443) {
            return server.getScheme() + "://" + server.getHost() + ":" + port;
        }
        return server.getScheme() + "://" + server.getHost();
    }

    protected String getDefaultHost(HttpRequest request) {
        ProxyHeaderParser proxyHeaderParser = new ProxyHeaderParser(request);
        if (proxyHeaderParser.getHost() != null) {
            return this.createHost(proxyHeaderParser.getScheme(), proxyHeaderParser.getHost(), proxyHeaderParser.getPort());
        }
        String hostHeader = (String)request.getHeaders().get((CharSequence)"Host");
        if (hostHeader != null) {
            return this.getConfiguredHost(request, null, "Host", null, true);
        }
        URI uri = request.getUri();
        if (uri.getHost() != null) {
            return this.createHost(uri.getScheme(), uri.getHost(), uri.getPort());
        }
        return this.getEmbeddedHost();
    }

    protected String getConfiguredHost(HttpRequest request, HttpServerConfiguration.HostResolutionConfiguration configuration) {
        return this.getConfiguredHost(request, configuration.getProtocolHeader(), configuration.getHostHeader(), configuration.getPortHeader(), configuration.isPortInHost());
    }

    protected String getConfiguredHost(HttpRequest request, String schemeHeader, String hostHeader, String portHeader, boolean isPortInHost) {
        Integer port;
        HttpHeaders headers = request.getHeaders();
        String scheme = null;
        if (schemeHeader != null) {
            scheme = (String)headers.get((CharSequence)schemeHeader);
        }
        if (scheme == null) {
            scheme = request.getUri().getScheme();
        }
        if (scheme == null) {
            scheme = ((EmbeddedServer)this.embeddedServer.get()).getScheme();
        }
        String host = null;
        if (hostHeader != null) {
            host = (String)headers.get((CharSequence)hostHeader);
        }
        if (host == null) {
            host = request.getUri().getHost();
        }
        if (host == null) {
            host = ((EmbeddedServer)this.embeddedServer.get()).getHost();
        }
        if (isPortInHost && host != null && host.contains(":")) {
            String[] parts = host.split(":");
            host = parts[0].trim();
            port = Integer.valueOf(parts[1].trim());
        } else if (portHeader != null) {
            port = headers.get((CharSequence)portHeader, Integer.class).orElse(null);
        } else {
            port = request.getUri().getPort();
            if (port < 0) {
                port = null;
            }
        }
        return this.createHost(scheme, host, port);
    }

    private String createHost(String scheme, String host, @Nullable Integer port) {
        if (port != null && port != 80 && port != 443) {
            return scheme + "://" + host + ":" + port;
        }
        return scheme + "://" + host;
    }
}

