/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.processor.BeanDefinitionProcessor;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RouteBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class AnnotatedFilterRouteBuilder
extends DefaultRouteBuilder
implements BeanDefinitionProcessor<Filter> {
    private final ServerContextPathProvider contextPathProvider;

    @Inject
    public AnnotatedFilterRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService conversionService, @Nullable ServerContextPathProvider contextPathProvider) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.contextPathProvider = contextPathProvider;
    }

    public void process(BeanDefinition<?> beanDefinition, BeanContext beanContext) {
        if (HttpClientFilter.class.isAssignableFrom(beanDefinition.getBeanType())) {
            return;
        }
        Object[] patterns = this.getPatterns(beanDefinition);
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            Object[] methods = (HttpMethod[])beanDefinition.enumValues(Filter.class, "methods", HttpMethod.class);
            FilterPatternStyle patternStyle = beanDefinition.enumValue(Filter.class, "patternStyle", FilterPatternStyle.class).orElse(FilterPatternStyle.ANT);
            Object first = patterns[0];
            FilterRoute filterRoute = this.addFilter((String)first, (BeanLocator)beanContext, beanDefinition);
            if (patterns.length > 1) {
                for (int i = 1; i < patterns.length; ++i) {
                    Object pattern = patterns[i];
                    filterRoute.pattern((String)pattern);
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])methods)) {
                filterRoute.methods((HttpMethod[])methods);
            }
            filterRoute.patternStyle(patternStyle);
        }
    }

    private String[] getPatterns(BeanDefinition<?> beanDefinition) {
        String contextPath;
        String[] values = beanDefinition.stringValues(Filter.class);
        String string = contextPath = this.contextPathProvider != null ? this.contextPathProvider.getContextPath() : null;
        if (contextPath != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i].startsWith(contextPath)) continue;
                Object newValue = StringUtils.prependUri((String)contextPath, (String)values[i]);
                if (((String)newValue).charAt(0) != '/') {
                    newValue = "/" + (String)newValue;
                }
                values[i] = newValue;
            }
        }
        return values;
    }
}

