/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriTemplateMatcher;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.executor.ThreadSelection;
import io.micronaut.web.router.DefaultRequestMatcher;
import io.micronaut.web.router.DefaultUriRouteMatch;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

@Internal
public final class DefaultUrlRouteInfo<T, R>
extends DefaultRequestMatcher<T, R>
implements UriRouteInfo<T, R> {
    private final HttpMethod httpMethod;
    private final UriMatchTemplate uriMatchTemplate;
    private final UriTemplateMatcher uriTemplateMatcher;
    private final Charset defaultCharset;
    private final Integer port;
    private final ConversionService conversionService;
    private final ExecutorSelector executorSelector;
    private boolean noExecutor;

    public DefaultUrlRouteInfo(HttpMethod httpMethod, UriMatchTemplate uriMatchTemplate, Charset defaultCharset, MethodExecutionHandle<T, R> targetMethod, @Nullable String bodyArgumentName, @Nullable Argument<?> bodyArgument, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, List<Predicate<HttpRequest<?>>> predicates, Integer port, ConversionService conversionService, ExecutorSelector executorSelector, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        super(targetMethod, bodyArgument, bodyArgumentName, consumesMediaTypes, producesMediaTypes, httpMethod.permitsRequestBody(), false, predicates, messageBodyHandlerRegistry);
        this.httpMethod = httpMethod;
        this.uriMatchTemplate = uriMatchTemplate;
        this.uriTemplateMatcher = new UriTemplateMatcher(uriMatchTemplate.getTemplateString());
        this.defaultCharset = defaultCharset;
        this.port = port;
        this.conversionService = conversionService;
        this.executorSelector = executorSelector;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public UriMatchTemplate getUriMatchTemplate() {
        return this.uriMatchTemplate;
    }

    @Override
    public Optional<UriRouteMatch<T, R>> match(String uri) {
        return Optional.ofNullable(this.tryMatch(uri));
    }

    @Override
    public UriRouteMatch<T, R> tryMatch(@NonNull String uri) {
        UriMatchInfo matchInfo = this.uriTemplateMatcher.tryMatch(uri);
        if (matchInfo != null) {
            return new DefaultUriRouteMatch(matchInfo, this, this.defaultCharset, this.conversionService);
        }
        return null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public int compareTo(@NonNull UriRouteInfo o) {
        return this.uriTemplateMatcher.compareTo(((DefaultUrlRouteInfo)o).uriTemplateMatcher);
    }

    public String toString() {
        return this.getHttpMethodName() + " " + String.valueOf(this.uriMatchTemplate) + " -> " + this.getTargetMethod().getDeclaringType().getSimpleName() + "#" + this.getTargetMethod().getName() + " (" + String.join((CharSequence)",", this.consumesMediaTypes) + ")";
    }

    @Override
    public ExecutorService getExecutor(ThreadSelection threadSelection) {
        if (this.executorSelector == null || this.noExecutor) {
            return null;
        }
        ExecutorService executor = this.executorSelector.select((MethodReference)this.getTargetMethod(), threadSelection).orElse(null);
        if (executor == null) {
            this.noExecutor = true;
        }
        return executor;
    }
}

