/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public interface Router {
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@NonNull CharSequence var1, @Nullable HttpRequest<?> var2);

    @NonNull
    public <T, R> List<UriRouteMatch<T, R>> findAny(@NonNull HttpRequest<?> var1);

    public Set<Integer> getExposedPorts();

    public void applyDefaultPorts(List<Integer> var1);

    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpMethod var1, @NonNull CharSequence var2, @Nullable HttpRequest<?> var3);

    @NonNull
    default public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpMethod httpMethod, @NonNull URI uri, @Nullable HttpRequest<?> context) {
        return this.find(httpMethod, uri.toString(), context);
    }

    @NonNull
    default public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request) {
        return this.find(request, request.getPath());
    }

    @NonNull
    default public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request, @NonNull CharSequence uri) {
        return this.find(HttpMethod.valueOf((String)request.getMethodName()), uri, request);
    }

    @NonNull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@NonNull HttpRequest<?> var1);

    @Nullable
    default public <T, R> UriRouteMatch<T, R> findClosest(@NonNull HttpRequest<?> request) throws DuplicateRouteException {
        List<UriRouteMatch<Object, Object>> uriRoutes = this.findAllClosest(request);
        if (uriRoutes.size() > 1) {
            throw new DuplicateRouteException(request.getPath(), uriRoutes);
        }
        if (uriRoutes.size() == 1) {
            return uriRoutes.get(0);
        }
        return null;
    }

    @NonNull
    public Stream<UriRouteInfo<?, ?>> uriRoutes();

    public <T, R> Optional<UriRouteMatch<T, R>> route(@NonNull HttpMethod var1, @NonNull CharSequence var2);

    public <R> Optional<RouteMatch<R>> route(@NonNull HttpStatus var1);

    public <R> Optional<RouteMatch<R>> route(@NonNull Class<?> var1, @NonNull HttpStatus var2);

    public <R> Optional<RouteMatch<R>> route(@NonNull Throwable var1);

    public <R> Optional<RouteMatch<R>> route(@NonNull Class<?> var1, @NonNull Throwable var2);

    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Class<?> var1, @NonNull Throwable var2, HttpRequest<?> var3);

    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Throwable var1, HttpRequest<?> var2);

    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull Class<?> var1, @NonNull HttpStatus var2, HttpRequest<?> var3);

    default public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull Class<?> originatingClass, int statusCode, HttpRequest<?> request) {
        HttpStatus status;
        try {
            status = HttpStatus.valueOf((int)statusCode);
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
        return this.findStatusRoute(originatingClass, status, request);
    }

    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull HttpStatus var1, HttpRequest<?> var2);

    default public <R> Optional<RouteMatch<R>> findStatusRoute(int statusCode, HttpRequest<?> request) {
        HttpStatus status;
        try {
            status = HttpStatus.valueOf((int)statusCode);
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
        return this.findStatusRoute(status, request);
    }

    @NonNull
    public List<GenericHttpFilter> findFilters(@NonNull HttpRequest<?> var1);

    @NonNull
    default public List<GenericHttpFilter> findFilters(@NonNull HttpRequest<?> request, @Nullable RouteMatch<?> routeMatch) {
        return this.findFilters(request);
    }

    @NonNull
    default public List<GenericHttpFilter> findPreMatchingFilters(@NonNull HttpRequest<?> request) {
        return List.of();
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> GET(@NonNull CharSequence uri) {
        return this.route(HttpMethod.GET, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> POST(@NonNull CharSequence uri) {
        return this.route(HttpMethod.POST, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PUT(@NonNull CharSequence uri) {
        return this.route(HttpMethod.PUT, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PATCH(@NonNull CharSequence uri) {
        return this.route(HttpMethod.PATCH, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> DELETE(@NonNull CharSequence uri) {
        return this.route(HttpMethod.DELETE, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> OPTIONS(@NonNull CharSequence uri) {
        return this.route(HttpMethod.OPTIONS, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> HEAD(@NonNull CharSequence uri) {
        return this.route(HttpMethod.HEAD, uri);
    }
}

