/*
 * Copyright 2017-2018 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.micronaut.runtime.context.scope;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import io.micronaut.aop.Around;

import javax.inject.Scope;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * A meta annotation for a scoped proxy.
 *
 * @author Graeme Rocher
 * @see ThreadLocal
 * @since 1.0
 */
@Around(proxyTarget = true, lazy = true)
@Scope
@Documented
@Retention(RUNTIME)
@Target({ElementType.ANNOTATION_TYPE})
public @interface ScopedProxy {
}
