/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.runtime.ApplicationConfiguration;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class CacheConfiguration {
    public static final String PREFIX = "micronaut.caches";
    public static final boolean DEFAULT_TESTMODE = false;
    protected Charset charset;
    private Integer initialCapacity;
    private Long maximumSize;
    private Long maximumWeight;
    private Duration expireAfterWrite;
    private Duration expireAfterAccess;
    private boolean testMode = false;
    private final String cacheName;

    public CacheConfiguration(@Parameter String cacheName, ApplicationConfiguration applicationConfiguration) {
        this.cacheName = cacheName;
        this.charset = applicationConfiguration.getDefaultCharset();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public OptionalInt getInitialCapacity() {
        return this.initialCapacity == null ? OptionalInt.empty() : OptionalInt.of(this.initialCapacity);
    }

    public OptionalLong getMaximumSize() {
        return this.maximumSize == null ? OptionalLong.empty() : OptionalLong.of(this.maximumSize);
    }

    public OptionalLong getMaximumWeight() {
        return this.maximumWeight == null ? OptionalLong.empty() : OptionalLong.of(this.maximumWeight);
    }

    public Optional<Duration> getExpireAfterWrite() {
        return Optional.ofNullable(this.expireAfterWrite);
    }

    public Optional<Duration> getExpireAfterAccess() {
        return Optional.ofNullable(this.expireAfterAccess);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setInitialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void setMaximumSize(Long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMaximumWeight(Long maximumWeight) {
        this.maximumWeight = maximumWeight;
    }

    public void setExpireAfterWrite(Duration expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public void setExpireAfterAccess(Duration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

