/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.Cache;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface SyncCache<C>
extends Cache<C> {
    public <T> Optional<T> get(Object var1, Argument<T> var2);

    public <T> T get(Object var1, Argument<T> var2, Supplier<T> var3);

    public <T> Optional<T> putIfAbsent(Object var1, T var2);

    public void put(Object var1, Object var2);

    public void invalidate(Object var1);

    public void invalidateAll();

    default public <T> T get(Object key, Class<T> requiredType, Supplier<T> supplier) {
        return this.get(key, Argument.of(requiredType), supplier);
    }

    default public <T> Optional<T> get(Object key, Class<T> requiredType) {
        return this.get(key, Argument.of(requiredType));
    }

    default public AsyncCache<C> async() {
        return new AsyncCache<C>(){

            @Override
            public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.get(key, requiredType));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.get(key, requiredType, supplier));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
                try {
                    return CompletableFuture.completedFuture(SyncCache.this.putIfAbsent(key, value));
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public String getName() {
                return SyncCache.this.getName();
            }

            @Override
            public C getNativeCache() {
                return SyncCache.this.getNativeCache();
            }

            @Override
            public CompletableFuture<Boolean> put(Object key, Object value) {
                try {
                    SyncCache.this.put(key, value);
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public CompletableFuture<Boolean> invalidate(Object key) {
                try {
                    SyncCache.this.invalidate(key);
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            @Override
            public CompletableFuture<Boolean> invalidateAll() {
                try {
                    SyncCache.this.invalidateAll();
                    return CompletableFuture.completedFuture(true);
                }
                catch (Exception e) {
                    return this.handleException(e);
                }
            }

            private <T> CompletableFuture<T> handleException(Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        };
    }
}

