/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.gcp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.NetworkInterface;
import io.micronaut.discovery.cloud.gcp.GoogleComputeInstanceMetadata;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataConfiguration;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataKeys;
import io.micronaut.discovery.cloud.gcp.GoogleComputeNetworkInterface;
import io.micronaut.http.HttpMethod;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"gcp"})
public class GoogleComputeInstanceMetadataResolver
implements ComputeInstanceMetadataResolver {
    public static final String HEADER_METADATA_FLAVOR = "Metadata-Flavor";
    private static final Logger LOG = LoggerFactory.getLogger(GoogleComputeInstanceMetadataResolver.class);
    private final ObjectMapper objectMapper;
    private final GoogleComputeMetadataConfiguration configuration;
    private GoogleComputeInstanceMetadata cachedMetadata;

    @Inject
    public GoogleComputeInstanceMetadataResolver(ObjectMapper objectMapper, GoogleComputeMetadataConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public GoogleComputeInstanceMetadataResolver() {
        this.objectMapper = new ObjectMapper();
        this.configuration = new GoogleComputeMetadataConfiguration();
    }

    @Override
    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        block9: {
            if (!this.configuration.isEnabled()) {
                return Optional.empty();
            }
            if (this.cachedMetadata != null) {
                this.cachedMetadata.cached = true;
                return Optional.of(this.cachedMetadata);
            }
            try {
                int connectionTimeoutMs = (int)this.configuration.getConnectTimeout().toMillis();
                int readTimeoutMs = (int)this.configuration.getReadTimeout().toMillis();
                JsonNode projectResultJson = this.readGcMetadataUrl(new URL(this.configuration.getProjectMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs);
                JsonNode instanceMetadataJson = this.readGcMetadataUrl(new URL(this.configuration.getMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs);
                if (instanceMetadataJson != null) {
                    GoogleComputeInstanceMetadata instanceMetadata = new GoogleComputeInstanceMetadata();
                    instanceMetadata.instanceId = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.ID.getName()).asText();
                    instanceMetadata.account = projectResultJson.findValue(GoogleComputeMetadataKeys.PROJECT_ID.getName()).textValue();
                    instanceMetadata.availabilityZone = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.ZONE.getName()).textValue();
                    instanceMetadata.machineType = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.MACHINE_TYPE.getName()).textValue();
                    instanceMetadata.description = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.DESCRIPTION.getName()).textValue();
                    instanceMetadata.imageId = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.IMAGE.getName()).textValue();
                    instanceMetadata.localHostname = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.HOSTNAME.getName()).textValue();
                    instanceMetadata.name = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.NAME.getName()).textValue();
                    JsonNode networkInterfaces = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.NETWORK_INTERFACES.getName());
                    ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                    AtomicReference<Integer> networkCounter = new AtomicReference<Integer>(0);
                    networkInterfaces.elements().forEachRemaining(jsonNode -> {
                        GoogleComputeNetworkInterface networkInterface = new GoogleComputeNetworkInterface();
                        networkInterface.setId(networkCounter.toString());
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName()) != null) {
                            JsonNode accessConfigs = jsonNode.findValue(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName());
                            instanceMetadata.publicIpV4 = accessConfigs.get(0).findValue("externalIp").textValue();
                        }
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.IP.getName()) != null) {
                            networkInterface.setIpv4(jsonNode.findValue(GoogleComputeMetadataKeys.IP.getName()).textValue());
                            instanceMetadata.privateIpV4 = jsonNode.findValue(GoogleComputeMetadataKeys.IP.getName()).textValue();
                        }
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.MAC.getName()) != null) {
                            networkInterface.setMac(jsonNode.findValue(GoogleComputeMetadataKeys.MAC.getName()).textValue());
                        }
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.NETWORK.getName()) != null) {
                            networkInterface.setNetwork(jsonNode.findValue(GoogleComputeMetadataKeys.NETWORK.getName()).textValue());
                        }
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.NETMASK.getName()) != null) {
                            networkInterface.setNetmask(jsonNode.findValue(GoogleComputeMetadataKeys.NETMASK.getName()).textValue());
                        }
                        if (jsonNode.findValue(GoogleComputeMetadataKeys.GATEWAY.getName()) != null) {
                            networkInterface.setGateway(jsonNode.findValue(GoogleComputeMetadataKeys.GATEWAY.getName()).textValue());
                        }
                        networkCounter.getAndSet((Integer)networkCounter.get() + 1);
                        interfaces.add(networkInterface);
                    });
                    instanceMetadata.interfaces = interfaces;
                    instanceMetadata.metadata = (Map)this.objectMapper.convertValue((Object)instanceMetadata, Map.class);
                    this.cachedMetadata = instanceMetadata;
                    return Optional.of(instanceMetadata);
                }
            }
            catch (MalformedURLException me) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Google compute metadataUrl value is invalid!: " + this.configuration.getMetadataUrl(), (Throwable)me);
                }
            }
            catch (FileNotFoundException fnfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No metadata found at: " + this.configuration.getMetadataUrl() + "?recursive=true", (Throwable)fnfe);
                }
            }
            catch (IOException | URISyntaxException ioe) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error("Error connecting to" + this.configuration.getMetadataUrl() + "?recursive=true reading instance metadata", (Throwable)ioe);
            }
        }
        return Optional.empty();
    }

    protected JsonNode readGcMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs) throws IOException, URISyntaxException {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), null, "");
            url = uri.toURL();
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            try (InputStream in = urlConnection.getInputStream();){
                JsonNode jsonNode = this.objectMapper.readTree(in);
                return jsonNode;
            }
        }
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        uc.setRequestProperty(HEADER_METADATA_FLAVOR, "Google");
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod(HttpMethod.GET.name());
        uc.setDoOutput(true);
        int responseCode = uc.getResponseCode();
        try (InputStream in = uc.getInputStream();){
            JsonNode jsonNode = this.objectMapper.readTree(in);
            return jsonNode;
        }
    }
}

